/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.LocalPref;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LocalPrefBuilder
implements Builder<LocalPref> {
    private Long _pref;
    Map<Class<? extends Augmentation<LocalPref>>, Augmentation<LocalPref>> augmentation = Collections.emptyMap();

    public LocalPrefBuilder() {
    }

    public LocalPrefBuilder(LocalPref base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LocalPref>>, Augmentation<LocalPref>>(aug);
        }
        this._pref = base.getPref();
    }

    public Long getPref() {
        return this._pref;
    }

    public <E$$ extends Augmentation<LocalPref>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkPrefRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public LocalPrefBuilder setPref(Long value) {
        if (value != null) {
            LocalPrefBuilder.checkPrefRange(value);
        }
        this._pref = value;
        return this;
    }

    public LocalPrefBuilder addAugmentation(Class<? extends Augmentation<LocalPref>> augmentationType, Augmentation<LocalPref> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LocalPref>>, Augmentation<LocalPref>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public LocalPrefBuilder removeAugmentation(Class<? extends Augmentation<LocalPref>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public LocalPref build() {
        return new LocalPrefImpl(this);
    }

    private static final class LocalPrefImpl
    extends AbstractAugmentable<LocalPref>
    implements LocalPref {
        private final Long _pref;
        private int hash = 0;
        private volatile boolean hashValid = false;

        LocalPrefImpl(LocalPrefBuilder base) {
            super(base.augmentation);
            this._pref = base.getPref();
        }

        @Override
        public Long getPref() {
            return this._pref;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._pref);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!LocalPref.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            LocalPref other = (LocalPref)obj;
            if (!Objects.equals(this._pref, other.getPref())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LocalPrefImpl otherImpl = (LocalPrefImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"LocalPref");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_pref", (Object)this._pref);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

