/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.MultiExitDisc;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MultiExitDiscBuilder
implements Builder<MultiExitDisc> {
    private Long _med;
    Map<Class<? extends Augmentation<MultiExitDisc>>, Augmentation<MultiExitDisc>> augmentation = Collections.emptyMap();

    public MultiExitDiscBuilder() {
    }

    public MultiExitDiscBuilder(MultiExitDisc base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MultiExitDisc>>, Augmentation<MultiExitDisc>>(aug);
        }
        this._med = base.getMed();
    }

    public Long getMed() {
        return this._med;
    }

    public <E$$ extends Augmentation<MultiExitDisc>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkMedRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public MultiExitDiscBuilder setMed(Long value) {
        if (value != null) {
            MultiExitDiscBuilder.checkMedRange(value);
        }
        this._med = value;
        return this;
    }

    public MultiExitDiscBuilder addAugmentation(Class<? extends Augmentation<MultiExitDisc>> augmentationType, Augmentation<MultiExitDisc> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MultiExitDisc>>, Augmentation<MultiExitDisc>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public MultiExitDiscBuilder removeAugmentation(Class<? extends Augmentation<MultiExitDisc>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MultiExitDisc build() {
        return new MultiExitDiscImpl(this);
    }

    private static final class MultiExitDiscImpl
    extends AbstractAugmentable<MultiExitDisc>
    implements MultiExitDisc {
        private final Long _med;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MultiExitDiscImpl(MultiExitDiscBuilder base) {
            super(base.augmentation);
            this._med = base.getMed();
        }

        @Override
        public Long getMed() {
            return this._med;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._med);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MultiExitDisc.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            MultiExitDisc other = (MultiExitDisc)obj;
            if (!Objects.equals(this._med, other.getMed())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MultiExitDiscImpl otherImpl = (MultiExitDiscImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"MultiExitDisc");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_med", (Object)this._med);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

