/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.UnrecognizedAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.UnrecognizedAttributesKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class UnrecognizedAttributesBuilder
implements Builder<UnrecognizedAttributes> {
    private Short _type;
    private byte[] _value;
    private Boolean _partial;
    private Boolean _transitive;
    private UnrecognizedAttributesKey key;
    Map<Class<? extends Augmentation<UnrecognizedAttributes>>, Augmentation<UnrecognizedAttributes>> augmentation = Collections.emptyMap();

    public UnrecognizedAttributesBuilder() {
    }

    public UnrecognizedAttributesBuilder(UnrecognizedAttributes base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UnrecognizedAttributes>>, Augmentation<UnrecognizedAttributes>>(aug);
        }
        this.key = base.key();
        this._type = base.getType();
        this._value = base.getValue();
        this._partial = base.isPartial();
        this._transitive = base.isTransitive();
    }

    public UnrecognizedAttributesKey key() {
        return this.key;
    }

    public Short getType() {
        return this._type;
    }

    public byte[] getValue() {
        return this._value == null ? null : (byte[])this._value.clone();
    }

    public Boolean isPartial() {
        return this._partial;
    }

    public Boolean isTransitive() {
        return this._transitive;
    }

    public <E$$ extends Augmentation<UnrecognizedAttributes>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public UnrecognizedAttributesBuilder withKey(UnrecognizedAttributesKey key) {
        this.key = key;
        return this;
    }

    private static void checkTypeRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..255]]", (int)value);
    }

    public UnrecognizedAttributesBuilder setType(Short value) {
        if (value != null) {
            UnrecognizedAttributesBuilder.checkTypeRange(value);
        }
        this._type = value;
        return this;
    }

    private static void check_valueLength(byte[] value) {
        int length = value.length;
        if (length <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[0..65535]]", (byte[])value);
    }

    public UnrecognizedAttributesBuilder setValue(byte[] value) {
        if (value != null) {
            UnrecognizedAttributesBuilder.check_valueLength(value);
        }
        this._value = value;
        return this;
    }

    public UnrecognizedAttributesBuilder setPartial(Boolean value) {
        this._partial = value;
        return this;
    }

    public UnrecognizedAttributesBuilder setTransitive(Boolean value) {
        this._transitive = value;
        return this;
    }

    public UnrecognizedAttributesBuilder addAugmentation(Class<? extends Augmentation<UnrecognizedAttributes>> augmentationType, Augmentation<UnrecognizedAttributes> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UnrecognizedAttributes>>, Augmentation<UnrecognizedAttributes>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public UnrecognizedAttributesBuilder removeAugmentation(Class<? extends Augmentation<UnrecognizedAttributes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public UnrecognizedAttributes build() {
        return new UnrecognizedAttributesImpl(this);
    }

    private static final class UnrecognizedAttributesImpl
    extends AbstractAugmentable<UnrecognizedAttributes>
    implements UnrecognizedAttributes {
        private final Short _type;
        private final byte[] _value;
        private final Boolean _partial;
        private final Boolean _transitive;
        private final UnrecognizedAttributesKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        UnrecognizedAttributesImpl(UnrecognizedAttributesBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new UnrecognizedAttributesKey(base.getType());
            this._type = this.key.getType();
            this._value = base.getValue();
            this._partial = base.isPartial();
            this._transitive = base.isTransitive();
        }

        @Override
        public UnrecognizedAttributesKey key() {
            return this.key;
        }

        @Override
        public Short getType() {
            return this._type;
        }

        @Override
        public byte[] getValue() {
            return this._value == null ? null : (byte[])this._value.clone();
        }

        @Override
        public Boolean isPartial() {
            return this._partial;
        }

        @Override
        public Boolean isTransitive() {
            return this._transitive;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._type);
            result = 31 * result + Arrays.hashCode(this._value);
            result = 31 * result + Objects.hashCode(this._partial);
            result = 31 * result + Objects.hashCode(this._transitive);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!UnrecognizedAttributes.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            UnrecognizedAttributes other = (UnrecognizedAttributes)obj;
            if (!Objects.equals(this._type, other.getType())) {
                return false;
            }
            if (!Arrays.equals(this._value, other.getValue())) {
                return false;
            }
            if (!Objects.equals(this._partial, other.isPartial())) {
                return false;
            }
            if (!Objects.equals(this._transitive, other.isTransitive())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                UnrecognizedAttributesImpl otherImpl = (UnrecognizedAttributesImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"UnrecognizedAttributes");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_type", (Object)this._type);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_value", (byte[])this._value);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_partial", (Object)this._partial);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_transitive", (Object)this._transitive);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

