/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.update.message;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.Ipv4PrefixAndPathId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.PathId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.PathIdGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.update.message.Nlri;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NlriBuilder
implements Builder<Nlri> {
    private PathId _pathId;
    private Ipv4Prefix _prefix;
    Map<Class<? extends Augmentation<Nlri>>, Augmentation<Nlri>> augmentation = Collections.emptyMap();

    public NlriBuilder() {
    }

    public NlriBuilder(Ipv4PrefixAndPathId arg) {
        this._prefix = arg.getPrefix();
        this._pathId = arg.getPathId();
    }

    public NlriBuilder(PathIdGrouping arg) {
        this._pathId = arg.getPathId();
    }

    public NlriBuilder(Nlri base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Nlri>>, Augmentation<Nlri>>(aug);
        }
        this._pathId = base.getPathId();
        this._prefix = base.getPrefix();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Ipv4PrefixAndPathId) {
            this._prefix = ((Ipv4PrefixAndPathId)arg).getPrefix();
            isValidArg = true;
        }
        if (arg instanceof PathIdGrouping) {
            this._pathId = ((PathIdGrouping)arg).getPathId();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.Ipv4PrefixAndPathId, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.PathIdGrouping]");
    }

    public PathId getPathId() {
        return this._pathId;
    }

    public Ipv4Prefix getPrefix() {
        return this._prefix;
    }

    public <E$$ extends Augmentation<Nlri>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public NlriBuilder setPathId(PathId value) {
        this._pathId = value;
        return this;
    }

    public NlriBuilder setPrefix(Ipv4Prefix value) {
        this._prefix = value;
        return this;
    }

    public NlriBuilder addAugmentation(Class<? extends Augmentation<Nlri>> augmentationType, Augmentation<Nlri> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Nlri>>, Augmentation<Nlri>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NlriBuilder removeAugmentation(Class<? extends Augmentation<Nlri>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Nlri build() {
        return new NlriImpl(this);
    }

    private static final class NlriImpl
    extends AbstractAugmentable<Nlri>
    implements Nlri {
        private final PathId _pathId;
        private final Ipv4Prefix _prefix;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NlriImpl(NlriBuilder base) {
            super(base.augmentation);
            this._pathId = base.getPathId();
            this._prefix = base.getPrefix();
        }

        @Override
        public PathId getPathId() {
            return this._pathId;
        }

        @Override
        public Ipv4Prefix getPrefix() {
            return this._prefix;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._pathId);
            result = 31 * result + Objects.hashCode(this._prefix);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Nlri.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            Nlri other = (Nlri)obj;
            if (!Objects.equals(this._pathId, other.getPathId())) {
                return false;
            }
            if (!Objects.equals(this._prefix, other.getPrefix())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NlriImpl otherImpl = (NlriImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Nlri");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_pathId", (Object)this._pathId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_prefix", (Object)this._prefix);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

