/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.RouteRefresh;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.SubsequentAddressFamily;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RouteRefreshBuilder
implements Builder<RouteRefresh> {
    private Class<? extends AddressFamily> _afi;
    private Class<? extends SubsequentAddressFamily> _safi;
    Map<Class<? extends Augmentation<RouteRefresh>>, Augmentation<RouteRefresh>> augmentation = Collections.emptyMap();

    public RouteRefreshBuilder() {
    }

    public RouteRefreshBuilder(BgpTableType arg) {
        this._afi = arg.getAfi();
        this._safi = arg.getSafi();
    }

    public RouteRefreshBuilder(RouteRefresh base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RouteRefresh>>, Augmentation<RouteRefresh>>(aug);
        }
        this._afi = base.getAfi();
        this._safi = base.getSafi();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BgpTableType) {
            this._afi = ((BgpTableType)arg).getAfi();
            this._safi = ((BgpTableType)arg).getSafi();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType]");
    }

    public Class<? extends AddressFamily> getAfi() {
        return this._afi;
    }

    public Class<? extends SubsequentAddressFamily> getSafi() {
        return this._safi;
    }

    public <E$$ extends Augmentation<RouteRefresh>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public RouteRefreshBuilder setAfi(Class<? extends AddressFamily> value) {
        this._afi = value;
        return this;
    }

    public RouteRefreshBuilder setSafi(Class<? extends SubsequentAddressFamily> value) {
        this._safi = value;
        return this;
    }

    public RouteRefreshBuilder addAugmentation(Class<? extends Augmentation<RouteRefresh>> augmentationType, Augmentation<RouteRefresh> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RouteRefresh>>, Augmentation<RouteRefresh>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public RouteRefreshBuilder removeAugmentation(Class<? extends Augmentation<RouteRefresh>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public RouteRefresh build() {
        return new RouteRefreshImpl(this);
    }

    private static final class RouteRefreshImpl
    extends AbstractAugmentable<RouteRefresh>
    implements RouteRefresh {
        private final Class<? extends AddressFamily> _afi;
        private final Class<? extends SubsequentAddressFamily> _safi;
        private int hash = 0;
        private volatile boolean hashValid = false;

        RouteRefreshImpl(RouteRefreshBuilder base) {
            super(base.augmentation);
            this._afi = base.getAfi();
            this._safi = base.getSafi();
        }

        @Override
        public Class<? extends AddressFamily> getAfi() {
            return this._afi;
        }

        @Override
        public Class<? extends SubsequentAddressFamily> getSafi() {
            return this._safi;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._afi);
            result = 31 * result + Objects.hashCode(this._safi);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RouteRefresh.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            RouteRefresh other = (RouteRefresh)obj;
            if (!Objects.equals(this._afi, other.getAfi())) {
                return false;
            }
            if (!Objects.equals(this._safi, other.getSafi())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RouteRefreshImpl otherImpl = (RouteRefreshImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"RouteRefresh");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_afi", this._afi);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_safi", this._safi);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

