/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.GracefulRestartCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.graceful.restart.capability.Tables;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GracefulRestartCapabilityBuilder
implements Builder<GracefulRestartCapability> {
    private GracefulRestartCapability.RestartFlags _restartFlags;
    private Integer _restartTime;
    private List<Tables> _tables;
    Map<Class<? extends Augmentation<GracefulRestartCapability>>, Augmentation<GracefulRestartCapability>> augmentation = Collections.emptyMap();

    public GracefulRestartCapabilityBuilder() {
    }

    public GracefulRestartCapabilityBuilder(GracefulRestartCapability base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GracefulRestartCapability>>, Augmentation<GracefulRestartCapability>>(aug);
        }
        this._restartFlags = base.getRestartFlags();
        this._restartTime = base.getRestartTime();
        this._tables = base.getTables();
    }

    public GracefulRestartCapability.RestartFlags getRestartFlags() {
        return this._restartFlags;
    }

    public Integer getRestartTime() {
        return this._restartTime;
    }

    public List<Tables> getTables() {
        return this._tables;
    }

    public <E$$ extends Augmentation<GracefulRestartCapability>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public GracefulRestartCapabilityBuilder setRestartFlags(GracefulRestartCapability.RestartFlags value) {
        this._restartFlags = value;
        return this;
    }

    private static void checkRestartTimeRange(int value) {
        if (value >= 0 && value <= 4095) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4095]]", (int)value);
    }

    public GracefulRestartCapabilityBuilder setRestartTime(Integer value) {
        if (value != null) {
            GracefulRestartCapabilityBuilder.checkRestartTimeRange(value);
        }
        this._restartTime = value;
        return this;
    }

    public GracefulRestartCapabilityBuilder setTables(List<Tables> values) {
        this._tables = values;
        return this;
    }

    public GracefulRestartCapabilityBuilder addAugmentation(Class<? extends Augmentation<GracefulRestartCapability>> augmentationType, Augmentation<GracefulRestartCapability> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GracefulRestartCapability>>, Augmentation<GracefulRestartCapability>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public GracefulRestartCapabilityBuilder removeAugmentation(Class<? extends Augmentation<GracefulRestartCapability>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public GracefulRestartCapability build() {
        return new GracefulRestartCapabilityImpl(this);
    }

    private static final class GracefulRestartCapabilityImpl
    extends AbstractAugmentable<GracefulRestartCapability>
    implements GracefulRestartCapability {
        private final GracefulRestartCapability.RestartFlags _restartFlags;
        private final Integer _restartTime;
        private final List<Tables> _tables;
        private int hash = 0;
        private volatile boolean hashValid = false;

        GracefulRestartCapabilityImpl(GracefulRestartCapabilityBuilder base) {
            super(base.augmentation);
            this._restartFlags = base.getRestartFlags();
            this._restartTime = base.getRestartTime();
            this._tables = base.getTables();
        }

        @Override
        public GracefulRestartCapability.RestartFlags getRestartFlags() {
            return this._restartFlags;
        }

        @Override
        public Integer getRestartTime() {
            return this._restartTime;
        }

        @Override
        public List<Tables> getTables() {
            return this._tables;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._restartFlags);
            result = 31 * result + Objects.hashCode(this._restartTime);
            result = 31 * result + Objects.hashCode(this._tables);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GracefulRestartCapability.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            GracefulRestartCapability other = (GracefulRestartCapability)obj;
            if (!Objects.equals(this._restartFlags, other.getRestartFlags())) {
                return false;
            }
            if (!Objects.equals(this._restartTime, other.getRestartTime())) {
                return false;
            }
            if (!Objects.equals(this._tables, other.getTables())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                GracefulRestartCapabilityImpl otherImpl = (GracefulRestartCapabilityImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"GracefulRestartCapability");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_restartFlags", (Object)this._restartFlags);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_restartTime", (Object)this._restartTime);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_tables", this._tables);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

