/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.add.path.capability;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpAddPathTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.SendReceive;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.add.path.capability.AddressFamilies;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.SubsequentAddressFamily;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AddressFamiliesBuilder
implements Builder<AddressFamilies> {
    private Class<? extends AddressFamily> _afi;
    private Class<? extends SubsequentAddressFamily> _safi;
    private SendReceive _sendReceive;
    Map<Class<? extends Augmentation<AddressFamilies>>, Augmentation<AddressFamilies>> augmentation = Collections.emptyMap();

    public AddressFamiliesBuilder() {
    }

    public AddressFamiliesBuilder(BgpAddPathTableType arg) {
        this._sendReceive = arg.getSendReceive();
        this._afi = arg.getAfi();
        this._safi = arg.getSafi();
    }

    public AddressFamiliesBuilder(BgpTableType arg) {
        this._afi = arg.getAfi();
        this._safi = arg.getSafi();
    }

    public AddressFamiliesBuilder(AddressFamilies base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AddressFamilies>>, Augmentation<AddressFamilies>>(aug);
        }
        this._afi = base.getAfi();
        this._safi = base.getSafi();
        this._sendReceive = base.getSendReceive();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BgpTableType) {
            this._afi = ((BgpTableType)arg).getAfi();
            this._safi = ((BgpTableType)arg).getSafi();
            isValidArg = true;
        }
        if (arg instanceof BgpAddPathTableType) {
            this._sendReceive = ((BgpAddPathTableType)arg).getSendReceive();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpAddPathTableType]");
    }

    public Class<? extends AddressFamily> getAfi() {
        return this._afi;
    }

    public Class<? extends SubsequentAddressFamily> getSafi() {
        return this._safi;
    }

    public SendReceive getSendReceive() {
        return this._sendReceive;
    }

    public <E$$ extends Augmentation<AddressFamilies>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public AddressFamiliesBuilder setAfi(Class<? extends AddressFamily> value) {
        this._afi = value;
        return this;
    }

    public AddressFamiliesBuilder setSafi(Class<? extends SubsequentAddressFamily> value) {
        this._safi = value;
        return this;
    }

    public AddressFamiliesBuilder setSendReceive(SendReceive value) {
        this._sendReceive = value;
        return this;
    }

    public AddressFamiliesBuilder addAugmentation(Class<? extends Augmentation<AddressFamilies>> augmentationType, Augmentation<AddressFamilies> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AddressFamilies>>, Augmentation<AddressFamilies>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public AddressFamiliesBuilder removeAugmentation(Class<? extends Augmentation<AddressFamilies>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public AddressFamilies build() {
        return new AddressFamiliesImpl(this);
    }

    private static final class AddressFamiliesImpl
    extends AbstractAugmentable<AddressFamilies>
    implements AddressFamilies {
        private final Class<? extends AddressFamily> _afi;
        private final Class<? extends SubsequentAddressFamily> _safi;
        private final SendReceive _sendReceive;
        private int hash = 0;
        private volatile boolean hashValid = false;

        AddressFamiliesImpl(AddressFamiliesBuilder base) {
            super(base.augmentation);
            this._afi = base.getAfi();
            this._safi = base.getSafi();
            this._sendReceive = base.getSendReceive();
        }

        @Override
        public Class<? extends AddressFamily> getAfi() {
            return this._afi;
        }

        @Override
        public Class<? extends SubsequentAddressFamily> getSafi() {
            return this._safi;
        }

        @Override
        public SendReceive getSendReceive() {
            return this._sendReceive;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._afi);
            result = 31 * result + Objects.hashCode(this._safi);
            result = 31 * result + Objects.hashCode((Object)this._sendReceive);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!AddressFamilies.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            AddressFamilies other = (AddressFamilies)obj;
            if (!Objects.equals(this._afi, other.getAfi())) {
                return false;
            }
            if (!Objects.equals(this._safi, other.getSafi())) {
                return false;
            }
            if (!Objects.equals((Object)this._sendReceive, (Object)other.getSendReceive())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AddressFamiliesImpl otherImpl = (AddressFamiliesImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"AddressFamilies");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_afi", this._afi);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_safi", this._safi);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_sendReceive", (Object)((Object)this._sendReceive));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

