/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability.Tables;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability.TablesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.SubsequentAddressFamily;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TablesBuilder
implements Builder<Tables> {
    private Class<? extends AddressFamily> _afi;
    private Tables.AfiFlags _afiFlags;
    private Long _longLivedStaleTime;
    private Class<? extends SubsequentAddressFamily> _safi;
    private TablesKey key;
    Map<Class<? extends Augmentation<Tables>>, Augmentation<Tables>> augmentation = Collections.emptyMap();

    public TablesBuilder() {
    }

    public TablesBuilder(BgpTableType arg) {
        this._afi = arg.getAfi();
        this._safi = arg.getSafi();
    }

    public TablesBuilder(Tables base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Tables>>, Augmentation<Tables>>(aug);
        }
        this.key = base.key();
        this._afi = base.getAfi();
        this._safi = base.getSafi();
        this._afiFlags = base.getAfiFlags();
        this._longLivedStaleTime = base.getLongLivedStaleTime();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BgpTableType) {
            this._afi = ((BgpTableType)arg).getAfi();
            this._safi = ((BgpTableType)arg).getSafi();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType]");
    }

    public TablesKey key() {
        return this.key;
    }

    public Class<? extends AddressFamily> getAfi() {
        return this._afi;
    }

    public Tables.AfiFlags getAfiFlags() {
        return this._afiFlags;
    }

    public Long getLongLivedStaleTime() {
        return this._longLivedStaleTime;
    }

    public Class<? extends SubsequentAddressFamily> getSafi() {
        return this._safi;
    }

    public <E$$ extends Augmentation<Tables>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public TablesBuilder withKey(TablesKey key) {
        this.key = key;
        return this;
    }

    public TablesBuilder setAfi(Class<? extends AddressFamily> value) {
        this._afi = value;
        return this;
    }

    public TablesBuilder setAfiFlags(Tables.AfiFlags value) {
        this._afiFlags = value;
        return this;
    }

    private static void checkLongLivedStaleTimeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..16777215]]", (long)value);
    }

    public TablesBuilder setLongLivedStaleTime(Long value) {
        if (value != null) {
            TablesBuilder.checkLongLivedStaleTimeRange(value);
        }
        this._longLivedStaleTime = value;
        return this;
    }

    public TablesBuilder setSafi(Class<? extends SubsequentAddressFamily> value) {
        this._safi = value;
        return this;
    }

    public TablesBuilder addAugmentation(Class<? extends Augmentation<Tables>> augmentationType, Augmentation<Tables> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Tables>>, Augmentation<Tables>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TablesBuilder removeAugmentation(Class<? extends Augmentation<Tables>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Tables build() {
        return new TablesImpl(this);
    }

    private static final class TablesImpl
    extends AbstractAugmentable<Tables>
    implements Tables {
        private final Class<? extends AddressFamily> _afi;
        private final Tables.AfiFlags _afiFlags;
        private final Long _longLivedStaleTime;
        private final Class<? extends SubsequentAddressFamily> _safi;
        private final TablesKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        TablesImpl(TablesBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new TablesKey(base.getAfi(), base.getSafi());
            this._afi = this.key.getAfi();
            this._safi = this.key.getSafi();
            this._afiFlags = base.getAfiFlags();
            this._longLivedStaleTime = base.getLongLivedStaleTime();
        }

        @Override
        public TablesKey key() {
            return this.key;
        }

        @Override
        public Class<? extends AddressFamily> getAfi() {
            return this._afi;
        }

        @Override
        public Tables.AfiFlags getAfiFlags() {
            return this._afiFlags;
        }

        @Override
        public Long getLongLivedStaleTime() {
            return this._longLivedStaleTime;
        }

        @Override
        public Class<? extends SubsequentAddressFamily> getSafi() {
            return this._safi;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._afi);
            result = 31 * result + Objects.hashCode(this._afiFlags);
            result = 31 * result + Objects.hashCode(this._longLivedStaleTime);
            result = 31 * result + Objects.hashCode(this._safi);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Tables.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            Tables other = (Tables)obj;
            if (!Objects.equals(this._afi, other.getAfi())) {
                return false;
            }
            if (!Objects.equals(this._afiFlags, other.getAfiFlags())) {
                return false;
            }
            if (!Objects.equals(this._longLivedStaleTime, other.getLongLivedStaleTime())) {
                return false;
            }
            if (!Objects.equals(this._safi, other.getSafi())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TablesImpl otherImpl = (TablesImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Tables");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_afi", this._afi);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_afiFlags", (Object)this._afiFlags);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_longLivedStaleTime", (Object)this._longLivedStaleTime);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_safi", this._safi);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

