/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.update.attributes;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.update.attributes.MpReachNlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.update.attributes.mp.reach.nlri.AdvertizedRoutes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.NextHop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.SubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.next.hop.CNextHop;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MpReachNlriBuilder
implements Builder<MpReachNlri> {
    private AdvertizedRoutes _advertizedRoutes;
    private Class<? extends AddressFamily> _afi;
    private CNextHop _cNextHop;
    private Class<? extends SubsequentAddressFamily> _safi;
    Map<Class<? extends Augmentation<MpReachNlri>>, Augmentation<MpReachNlri>> augmentation = Collections.emptyMap();

    public MpReachNlriBuilder() {
    }

    public MpReachNlriBuilder(BgpTableType arg) {
        this._afi = arg.getAfi();
        this._safi = arg.getSafi();
    }

    public MpReachNlriBuilder(NextHop arg) {
        this._cNextHop = arg.getCNextHop();
    }

    public MpReachNlriBuilder(MpReachNlri base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MpReachNlri>>, Augmentation<MpReachNlri>>(aug);
        }
        this._advertizedRoutes = base.getAdvertizedRoutes();
        this._afi = base.getAfi();
        this._cNextHop = base.getCNextHop();
        this._safi = base.getSafi();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BgpTableType) {
            this._afi = ((BgpTableType)arg).getAfi();
            this._safi = ((BgpTableType)arg).getSafi();
            isValidArg = true;
        }
        if (arg instanceof NextHop) {
            this._cNextHop = ((NextHop)arg).getCNextHop();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.NextHop]");
    }

    public AdvertizedRoutes getAdvertizedRoutes() {
        return this._advertizedRoutes;
    }

    public Class<? extends AddressFamily> getAfi() {
        return this._afi;
    }

    public CNextHop getCNextHop() {
        return this._cNextHop;
    }

    public Class<? extends SubsequentAddressFamily> getSafi() {
        return this._safi;
    }

    public <E$$ extends Augmentation<MpReachNlri>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public MpReachNlriBuilder setAdvertizedRoutes(AdvertizedRoutes value) {
        this._advertizedRoutes = value;
        return this;
    }

    public MpReachNlriBuilder setAfi(Class<? extends AddressFamily> value) {
        this._afi = value;
        return this;
    }

    public MpReachNlriBuilder setCNextHop(CNextHop value) {
        this._cNextHop = value;
        return this;
    }

    public MpReachNlriBuilder setSafi(Class<? extends SubsequentAddressFamily> value) {
        this._safi = value;
        return this;
    }

    public MpReachNlriBuilder addAugmentation(Class<? extends Augmentation<MpReachNlri>> augmentationType, Augmentation<MpReachNlri> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MpReachNlri>>, Augmentation<MpReachNlri>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public MpReachNlriBuilder removeAugmentation(Class<? extends Augmentation<MpReachNlri>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MpReachNlri build() {
        return new MpReachNlriImpl(this);
    }

    private static final class MpReachNlriImpl
    extends AbstractAugmentable<MpReachNlri>
    implements MpReachNlri {
        private final AdvertizedRoutes _advertizedRoutes;
        private final Class<? extends AddressFamily> _afi;
        private final CNextHop _cNextHop;
        private final Class<? extends SubsequentAddressFamily> _safi;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MpReachNlriImpl(MpReachNlriBuilder base) {
            super(base.augmentation);
            this._advertizedRoutes = base.getAdvertizedRoutes();
            this._afi = base.getAfi();
            this._cNextHop = base.getCNextHop();
            this._safi = base.getSafi();
        }

        @Override
        public AdvertizedRoutes getAdvertizedRoutes() {
            return this._advertizedRoutes;
        }

        @Override
        public Class<? extends AddressFamily> getAfi() {
            return this._afi;
        }

        public CNextHop getCNextHop() {
            return this._cNextHop;
        }

        @Override
        public Class<? extends SubsequentAddressFamily> getSafi() {
            return this._safi;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._advertizedRoutes);
            result = 31 * result + Objects.hashCode(this._afi);
            result = 31 * result + Objects.hashCode(this._cNextHop);
            result = 31 * result + Objects.hashCode(this._safi);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MpReachNlri.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            MpReachNlri other = (MpReachNlri)obj;
            if (!Objects.equals(this._advertizedRoutes, other.getAdvertizedRoutes())) {
                return false;
            }
            if (!Objects.equals(this._afi, other.getAfi())) {
                return false;
            }
            if (!Objects.equals(this._cNextHop, other.getCNextHop())) {
                return false;
            }
            if (!Objects.equals(this._safi, other.getSafi())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MpReachNlriImpl otherImpl = (MpReachNlriImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"MpReachNlri");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_advertizedRoutes", (Object)this._advertizedRoutes);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_afi", this._afi);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_cNextHop", (Object)this._cNextHop);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_safi", this._safi);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

