/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.UnrecognizedAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.UnrecognizedAttributesKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint8;

public class UnrecognizedAttributesBuilder
implements Builder<UnrecognizedAttributes> {
    private Boolean _partial;
    private Boolean _transitive;
    private Uint8 _type;
    private byte[] _value;
    private UnrecognizedAttributesKey key;
    Map<Class<? extends Augmentation<UnrecognizedAttributes>>, Augmentation<UnrecognizedAttributes>> augmentation = Collections.emptyMap();

    public UnrecognizedAttributesBuilder() {
    }

    public UnrecognizedAttributesBuilder(UnrecognizedAttributes base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UnrecognizedAttributes>>, Augmentation<UnrecognizedAttributes>>(aug);
        }
        this.key = base.key();
        this._type = base.getType();
        this._partial = base.getPartial();
        this._transitive = base.getTransitive();
        this._value = base.getValue();
    }

    public UnrecognizedAttributesKey key() {
        return this.key;
    }

    public Boolean getPartial() {
        return this._partial;
    }

    @Deprecated(forRemoval=true)
    public final Boolean isPartial() {
        return this.getPartial();
    }

    public Boolean getTransitive() {
        return this._transitive;
    }

    @Deprecated(forRemoval=true)
    public final Boolean isTransitive() {
        return this.getTransitive();
    }

    public Uint8 getType() {
        return this._type;
    }

    public byte[] getValue() {
        return this._value == null ? null : (byte[])this._value.clone();
    }

    public <E$$ extends Augmentation<UnrecognizedAttributes>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public UnrecognizedAttributesBuilder withKey(UnrecognizedAttributesKey key) {
        this.key = key;
        return this;
    }

    public UnrecognizedAttributesBuilder setPartial(Boolean value) {
        this._partial = value;
        return this;
    }

    public UnrecognizedAttributesBuilder setTransitive(Boolean value) {
        this._transitive = value;
        return this;
    }

    public UnrecognizedAttributesBuilder setType(Uint8 value) {
        this._type = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public UnrecognizedAttributesBuilder setType(Short value) {
        return this.setType(CodeHelpers.compatUint((Short)value));
    }

    private static void check_valueLength(byte[] value) {
        int length = value.length;
        if (length <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[0..65535]]", (byte[])value);
    }

    public UnrecognizedAttributesBuilder setValue(byte[] value) {
        if (value != null) {
            UnrecognizedAttributesBuilder.check_valueLength(value);
        }
        this._value = value;
        return this;
    }

    public UnrecognizedAttributesBuilder addAugmentation(Augmentation<UnrecognizedAttributes> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UnrecognizedAttributes>>, Augmentation<UnrecognizedAttributes>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public UnrecognizedAttributesBuilder removeAugmentation(Class<? extends Augmentation<UnrecognizedAttributes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public UnrecognizedAttributes build() {
        return new UnrecognizedAttributesImpl(this);
    }

    private static final class UnrecognizedAttributesImpl
    extends AbstractAugmentable<UnrecognizedAttributes>
    implements UnrecognizedAttributes {
        private final Boolean _partial;
        private final Boolean _transitive;
        private final Uint8 _type;
        private final byte[] _value;
        private final UnrecognizedAttributesKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        UnrecognizedAttributesImpl(UnrecognizedAttributesBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new UnrecognizedAttributesKey(base.getType());
            this._type = this.key.getType();
            this._partial = base.getPartial();
            this._transitive = base.getTransitive();
            this._value = base.getValue();
        }

        @Override
        public UnrecognizedAttributesKey key() {
            return this.key;
        }

        @Override
        public Boolean getPartial() {
            return this._partial;
        }

        @Override
        public Boolean getTransitive() {
            return this._transitive;
        }

        @Override
        public Uint8 getType() {
            return this._type;
        }

        @Override
        public byte[] getValue() {
            return this._value == null ? null : (byte[])this._value.clone();
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = UnrecognizedAttributes.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return UnrecognizedAttributes.bindingEquals(this, obj);
        }

        public String toString() {
            return UnrecognizedAttributes.bindingToString(this);
        }
    }
}

