/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.MultiprotocolCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MultiprotocolCapabilityBuilder
implements Builder<MultiprotocolCapability> {
    private Class<? extends AddressFamily> _afi;
    private Class<? extends SubsequentAddressFamily> _safi;
    Map<Class<? extends Augmentation<MultiprotocolCapability>>, Augmentation<MultiprotocolCapability>> augmentation = Collections.emptyMap();

    public MultiprotocolCapabilityBuilder() {
    }

    public MultiprotocolCapabilityBuilder(BgpTableType arg) {
        this._afi = arg.getAfi();
        this._safi = arg.getSafi();
    }

    public MultiprotocolCapabilityBuilder(MultiprotocolCapability base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MultiprotocolCapability>>, Augmentation<MultiprotocolCapability>>(aug);
        }
        this._afi = base.getAfi();
        this._safi = base.getSafi();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BgpTableType) {
            this._afi = ((BgpTableType)arg).getAfi();
            this._safi = ((BgpTableType)arg).getSafi();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType]");
    }

    public Class<? extends AddressFamily> getAfi() {
        return this._afi;
    }

    public Class<? extends SubsequentAddressFamily> getSafi() {
        return this._safi;
    }

    public <E$$ extends Augmentation<MultiprotocolCapability>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public MultiprotocolCapabilityBuilder setAfi(Class<? extends AddressFamily> value) {
        this._afi = value;
        return this;
    }

    public MultiprotocolCapabilityBuilder setSafi(Class<? extends SubsequentAddressFamily> value) {
        this._safi = value;
        return this;
    }

    public MultiprotocolCapabilityBuilder addAugmentation(Augmentation<MultiprotocolCapability> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MultiprotocolCapability>>, Augmentation<MultiprotocolCapability>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MultiprotocolCapabilityBuilder removeAugmentation(Class<? extends Augmentation<MultiprotocolCapability>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MultiprotocolCapability build() {
        return new MultiprotocolCapabilityImpl(this);
    }

    private static final class MultiprotocolCapabilityImpl
    extends AbstractAugmentable<MultiprotocolCapability>
    implements MultiprotocolCapability {
        private final Class<? extends AddressFamily> _afi;
        private final Class<? extends SubsequentAddressFamily> _safi;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MultiprotocolCapabilityImpl(MultiprotocolCapabilityBuilder base) {
            super(base.augmentation);
            this._afi = base.getAfi();
            this._safi = base.getSafi();
        }

        @Override
        public Class<? extends AddressFamily> getAfi() {
            return this._afi;
        }

        @Override
        public Class<? extends SubsequentAddressFamily> getSafi() {
            return this._safi;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = MultiprotocolCapability.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return MultiprotocolCapability.bindingEquals(this, obj);
        }

        public String toString() {
            return MultiprotocolCapability.bindingToString(this);
        }
    }
}

