package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-message</b>
 * <pre>
 * grouping ipv4-prefix-and-path-id {
 *   leaf prefix {
 *     type inet:ipv4-prefix;
 *   }
 *   uses path-id-grouping;
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-messageipv4-prefix-and-path-id</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface Ipv4PrefixAndPathId
    extends
    DataObject,
    PathIdGrouping
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("ipv4-prefix-and-path-id");

    @Override
    Class<? extends Ipv4PrefixAndPathId> implementedInterface();
    
    /**
     * Return prefix, or {@code null} if it is not present.
     *
     * @return {@code Ipv4Prefix} prefix, or {@code null} if it is not present.
     *
     */
    Ipv4Prefix getPrefix();
    
    /**
     * Return prefix, guaranteed to be non-null.
     *
     * @return {@code Ipv4Prefix} prefix, guaranteed to be non-null.
     * @throws NoSuchElementException if prefix is not present
     *
     */
    default @NonNull Ipv4Prefix requirePrefix() {
        return CodeHelpers.require(getPrefix(), "prefix");
    }

}

