package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Notification Message
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-message</b>
 * <pre>
 * grouping notify-message {
 *   leaf error-code {
 *     type uint8;
 *   }
 *   leaf error-subcode {
 *     type uint8;
 *   }
 *   leaf data {
 *     type binary;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-messagenotify-message</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface NotifyMessage
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("notify-message");

    @Override
    Class<? extends NotifyMessage> implementedInterface();
    
    /**
     * Return errorCode, or {@code null} if it is not present.
     *
     * @return {@code Uint8} errorCode, or {@code null} if it is not present.
     *
     */
    Uint8 getErrorCode();
    
    /**
     * Return errorCode, guaranteed to be non-null.
     *
     * @return {@code Uint8} errorCode, guaranteed to be non-null.
     * @throws NoSuchElementException if errorCode is not present
     *
     */
    default @NonNull Uint8 requireErrorCode() {
        return CodeHelpers.require(getErrorCode(), "errorcode");
    }
    
    /**
     * Return errorSubcode, or {@code null} if it is not present.
     *
     * @return {@code Uint8} errorSubcode, or {@code null} if it is not present.
     *
     */
    Uint8 getErrorSubcode();
    
    /**
     * Return errorSubcode, guaranteed to be non-null.
     *
     * @return {@code Uint8} errorSubcode, guaranteed to be non-null.
     * @throws NoSuchElementException if errorSubcode is not present
     *
     */
    default @NonNull Uint8 requireErrorSubcode() {
        return CodeHelpers.require(getErrorSubcode(), "errorsubcode");
    }
    
    /**
     * Return data, or {@code null} if it is not present.
     *
     * @return {@code byte[]} data, or {@code null} if it is not present.
     *
     */
    byte[] getData();
    
    /**
     * Return data, guaranteed to be non-null.
     *
     * @return {@code byte[]} data, guaranteed to be non-null.
     * @throws NoSuchElementException if data is not present
     *
     */
    default byte @NonNull[] requireData() {
        return CodeHelpers.require(getData(), "data");
    }

}

