package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-message</b>
 * <pre>
 * grouping path-id-grouping {
 *   leaf path-id {
 *     type path-id;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-messagepath-id-grouping</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface PathIdGrouping
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("path-id-grouping");

    @Override
    Class<? extends PathIdGrouping> implementedInterface();
    
    /**
     * Return pathId, or {@code null} if it is not present.
     *
     * @return {@code PathId} pathId, or {@code null} if it is not present.
     *
     */
    PathId getPathId();
    
    /**
     * Return pathId, guaranteed to be non-null.
     *
     * @return {@code PathId} pathId, guaranteed to be non-null.
     * @throws NoSuchElementException if pathId is not present
     *
     */
    default @NonNull PathId requirePathId() {
        return CodeHelpers.require(getPathId(), "pathid");
    }

}

