package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.update.message.Nlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.update.message.WithdrawnRoutes;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Update Message
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-message</b>
 * <pre>
 * grouping update-message {
 *   uses path-attributes;
 *   list withdrawn-routes {
 *     uses ipv4-prefix-and-path-id;
 *   }
 *   list nlri {
 *     uses ipv4-prefix-and-path-id;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-messageupdate-message</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface UpdateMessage
    extends
    DataObject,
    PathAttributes
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("update-message");

    @Override
    Class<? extends UpdateMessage> implementedInterface();
    
    /**
     * Return withdrawnRoutes, or {@code null} if it is not present.
     *
     * @return {@code List<WithdrawnRoutes>} withdrawnRoutes, or {@code null} if it is not present.
     *
     */
    @Nullable List<WithdrawnRoutes> getWithdrawnRoutes();
    
    /**
     * Return withdrawnRoutes, or an empty list if it is not present.
     *
     * @return {@code List<WithdrawnRoutes>} withdrawnRoutes, or an empty list if it is not present.
     *
     */
    default @NonNull List<WithdrawnRoutes> nonnullWithdrawnRoutes() {
        return CodeHelpers.nonnull(getWithdrawnRoutes());
    }
    
    /**
     * Return nlri, or {@code null} if it is not present.
     *
     * @return {@code List<Nlri>} nlri, or {@code null} if it is not present.
     *
     */
    @Nullable List<Nlri> getNlri();
    
    /**
     * Return nlri, or an empty list if it is not present.
     *
     * @return {@code List<Nlri>} nlri, or an empty list if it is not present.
     *
     */
    default @NonNull List<Nlri> nonnullNlri() {
        return CodeHelpers.nonnull(getNlri());
    }

}

