package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParameters;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link OptionalCapabilities} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     OptionalCapabilities createOptionalCapabilities(int fooXyzzy, int barBaz) {
 *         return new OptionalCapabilitiesBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of OptionalCapabilities, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see OptionalCapabilities
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class OptionalCapabilitiesBuilder implements Builder<OptionalCapabilities> {

    private CParameters _cParameters;


    Map<Class<? extends Augmentation<OptionalCapabilities>>, Augmentation<OptionalCapabilities>> augmentation = Collections.emptyMap();

    public OptionalCapabilitiesBuilder() {
    }
    
    

    public OptionalCapabilitiesBuilder(OptionalCapabilities base) {
        Map<Class<? extends Augmentation<OptionalCapabilities>>, Augmentation<OptionalCapabilities>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._cParameters = base.getCParameters();
    }


    public CParameters getCParameters() {
        return _cParameters;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<OptionalCapabilities>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public OptionalCapabilitiesBuilder setCParameters(final CParameters value) {
        this._cParameters = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public OptionalCapabilitiesBuilder addAugmentation(Augmentation<OptionalCapabilities> augmentation) {
        Class<? extends Augmentation<OptionalCapabilities>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public OptionalCapabilitiesBuilder removeAugmentation(Class<? extends Augmentation<OptionalCapabilities>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public OptionalCapabilities build() {
        return new OptionalCapabilitiesImpl(this);
    }

    private static final class OptionalCapabilitiesImpl
        extends AbstractAugmentable<OptionalCapabilities>
        implements OptionalCapabilities {
    
        private final CParameters _cParameters;
    
        OptionalCapabilitiesImpl(OptionalCapabilitiesBuilder base) {
            super(base.augmentation);
            this._cParameters = base.getCParameters();
        }
    
        @Override
        public CParameters getCParameters() {
            return _cParameters;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = OptionalCapabilities.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return OptionalCapabilities.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return OptionalCapabilities.bindingToString(this);
        }
    }
}
