package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.c.parameters.As4BytesCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.c.parameters.BgpExtendedMessageCapability;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link CParameters} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     CParameters createCParameters(int fooXyzzy, int barBaz) {
 *         return new CParametersBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of CParameters, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see CParameters
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class CParametersBuilder implements Builder<CParameters> {

    private As4BytesCapability _as4BytesCapability;
    private BgpExtendedMessageCapability _bgpExtendedMessageCapability;


    Map<Class<? extends Augmentation<CParameters>>, Augmentation<CParameters>> augmentation = Collections.emptyMap();

    public CParametersBuilder() {
    }
    
    

    public CParametersBuilder(CParameters base) {
        Map<Class<? extends Augmentation<CParameters>>, Augmentation<CParameters>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._as4BytesCapability = base.getAs4BytesCapability();
        this._bgpExtendedMessageCapability = base.getBgpExtendedMessageCapability();
    }


    public As4BytesCapability getAs4BytesCapability() {
        return _as4BytesCapability;
    }
    
    public BgpExtendedMessageCapability getBgpExtendedMessageCapability() {
        return _bgpExtendedMessageCapability;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<CParameters>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public CParametersBuilder setAs4BytesCapability(final As4BytesCapability value) {
        this._as4BytesCapability = value;
        return this;
    }
    
    public CParametersBuilder setBgpExtendedMessageCapability(final BgpExtendedMessageCapability value) {
        this._bgpExtendedMessageCapability = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public CParametersBuilder addAugmentation(Augmentation<CParameters> augmentation) {
        Class<? extends Augmentation<CParameters>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public CParametersBuilder removeAugmentation(Class<? extends Augmentation<CParameters>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public CParameters build() {
        return new CParametersImpl(this);
    }

    private static final class CParametersImpl
        extends AbstractAugmentable<CParameters>
        implements CParameters {
    
        private final As4BytesCapability _as4BytesCapability;
        private final BgpExtendedMessageCapability _bgpExtendedMessageCapability;
    
        CParametersImpl(CParametersBuilder base) {
            super(base.augmentation);
            this._as4BytesCapability = base.getAs4BytesCapability();
            this._bgpExtendedMessageCapability = base.getBgpExtendedMessageCapability();
        }
    
        @Override
        public As4BytesCapability getAs4BytesCapability() {
            return _as4BytesCapability;
        }
        
        @Override
        public BgpExtendedMessageCapability getBgpExtendedMessageCapability() {
            return _bgpExtendedMessageCapability;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = CParameters.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return CParameters.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return CParameters.bindingToString(this);
        }
    }
}
