package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.c.parameters;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link As4BytesCapability} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     As4BytesCapability createAs4BytesCapability(int fooXyzzy, int barBaz) {
 *         return new As4BytesCapabilityBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of As4BytesCapability, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see As4BytesCapability
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class As4BytesCapabilityBuilder implements Builder<As4BytesCapability> {

    private AsNumber _asNumber;


    Map<Class<? extends Augmentation<As4BytesCapability>>, Augmentation<As4BytesCapability>> augmentation = Collections.emptyMap();

    public As4BytesCapabilityBuilder() {
    }
    
    

    public As4BytesCapabilityBuilder(As4BytesCapability base) {
        Map<Class<? extends Augmentation<As4BytesCapability>>, Augmentation<As4BytesCapability>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._asNumber = base.getAsNumber();
    }


    public AsNumber getAsNumber() {
        return _asNumber;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<As4BytesCapability>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public As4BytesCapabilityBuilder setAsNumber(final AsNumber value) {
        this._asNumber = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public As4BytesCapabilityBuilder addAugmentation(Augmentation<As4BytesCapability> augmentation) {
        Class<? extends Augmentation<As4BytesCapability>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public As4BytesCapabilityBuilder removeAugmentation(Class<? extends Augmentation<As4BytesCapability>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public As4BytesCapability build() {
        return new As4BytesCapabilityImpl(this);
    }

    private static final class As4BytesCapabilityImpl
        extends AbstractAugmentable<As4BytesCapability>
        implements As4BytesCapability {
    
        private final AsNumber _asNumber;
    
        As4BytesCapabilityImpl(As4BytesCapabilityBuilder base) {
            super(base.augmentation);
            this._asNumber = base.getAsNumber();
        }
    
        @Override
        public AsNumber getAsNumber() {
            return _asNumber;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = As4BytesCapability.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return As4BytesCapability.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return As4BytesCapability.bindingToString(this);
        }
    }
}
