package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Aggregator;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Aigp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AsPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AtomicAggregate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.BgpPrefixSid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ClusterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Communities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ExtendedCommunities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.LocalPref;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.MultiExitDisc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Origin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.OriginatorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.UnrecognizedAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.UnrecognizedAttributesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.NextHop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.CNextHop;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Attributes} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Attributes createAttributes(int fooXyzzy, int barBaz) {
 *         return new AttributesBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Attributes, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Attributes
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class AttributesBuilder implements Builder<Attributes> {

    private Aggregator _aggregator;
    private Aigp _aigp;
    private AsPath _asPath;
    private AtomicAggregate _atomicAggregate;
    private BgpPrefixSid _bgpPrefixSid;
    private CNextHop _cNextHop;
    private ClusterId _clusterId;
    private List<Communities> _communities;
    private List<ExtendedCommunities> _extendedCommunities;
    private LocalPref _localPref;
    private MultiExitDisc _multiExitDisc;
    private Origin _origin;
    private OriginatorId _originatorId;
    private Map<UnrecognizedAttributesKey, UnrecognizedAttributes> _unrecognizedAttributes;


    Map<Class<? extends Augmentation<Attributes>>, Augmentation<Attributes>> augmentation = Collections.emptyMap();

    public AttributesBuilder() {
    }
    
    
    
    public AttributesBuilder(NextHop arg) {
        this._cNextHop = arg.getCNextHop();
    }

    public AttributesBuilder(Attributes base) {
        Map<Class<? extends Augmentation<Attributes>>, Augmentation<Attributes>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._aggregator = base.getAggregator();
        this._aigp = base.getAigp();
        this._asPath = base.getAsPath();
        this._atomicAggregate = base.getAtomicAggregate();
        this._bgpPrefixSid = base.getBgpPrefixSid();
        this._cNextHop = base.getCNextHop();
        this._clusterId = base.getClusterId();
        this._communities = base.getCommunities();
        this._extendedCommunities = base.getExtendedCommunities();
        this._localPref = base.getLocalPref();
        this._multiExitDisc = base.getMultiExitDisc();
        this._origin = base.getOrigin();
        this._originatorId = base.getOriginatorId();
        this._unrecognizedAttributes = base.getUnrecognizedAttributes();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>NextHop</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NextHop) {
            this._cNextHop = ((NextHop)arg).getCNextHop();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[NextHop]");
    }

    public Aggregator getAggregator() {
        return _aggregator;
    }
    
    public Aigp getAigp() {
        return _aigp;
    }
    
    public AsPath getAsPath() {
        return _asPath;
    }
    
    public AtomicAggregate getAtomicAggregate() {
        return _atomicAggregate;
    }
    
    public BgpPrefixSid getBgpPrefixSid() {
        return _bgpPrefixSid;
    }
    
    public CNextHop getCNextHop() {
        return _cNextHop;
    }
    
    public ClusterId getClusterId() {
        return _clusterId;
    }
    
    public List<Communities> getCommunities() {
        return _communities;
    }
    
    public List<ExtendedCommunities> getExtendedCommunities() {
        return _extendedCommunities;
    }
    
    public LocalPref getLocalPref() {
        return _localPref;
    }
    
    public MultiExitDisc getMultiExitDisc() {
        return _multiExitDisc;
    }
    
    public Origin getOrigin() {
        return _origin;
    }
    
    public OriginatorId getOriginatorId() {
        return _originatorId;
    }
    
    public Map<UnrecognizedAttributesKey, UnrecognizedAttributes> getUnrecognizedAttributes() {
        return _unrecognizedAttributes;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Attributes>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public AttributesBuilder setAggregator(final Aggregator value) {
        this._aggregator = value;
        return this;
    }
    
    public AttributesBuilder setAigp(final Aigp value) {
        this._aigp = value;
        return this;
    }
    
    public AttributesBuilder setAsPath(final AsPath value) {
        this._asPath = value;
        return this;
    }
    
    public AttributesBuilder setAtomicAggregate(final AtomicAggregate value) {
        this._atomicAggregate = value;
        return this;
    }
    
    public AttributesBuilder setBgpPrefixSid(final BgpPrefixSid value) {
        this._bgpPrefixSid = value;
        return this;
    }
    
    public AttributesBuilder setCNextHop(final CNextHop value) {
        this._cNextHop = value;
        return this;
    }
    
    public AttributesBuilder setClusterId(final ClusterId value) {
        this._clusterId = value;
        return this;
    }
    public AttributesBuilder setCommunities(final List<Communities> values) {
        this._communities = values;
        return this;
    }
    
    public AttributesBuilder setExtendedCommunities(final List<ExtendedCommunities> values) {
        this._extendedCommunities = values;
        return this;
    }
    
    
    public AttributesBuilder setLocalPref(final LocalPref value) {
        this._localPref = value;
        return this;
    }
    
    public AttributesBuilder setMultiExitDisc(final MultiExitDisc value) {
        this._multiExitDisc = value;
        return this;
    }
    
    public AttributesBuilder setOrigin(final Origin value) {
        this._origin = value;
        return this;
    }
    
    public AttributesBuilder setOriginatorId(final OriginatorId value) {
        this._originatorId = value;
        return this;
    }
    public AttributesBuilder setUnrecognizedAttributes(final Map<UnrecognizedAttributesKey, UnrecognizedAttributes> values) {
        this._unrecognizedAttributes = values;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public AttributesBuilder addAugmentation(Augmentation<Attributes> augmentation) {
        Class<? extends Augmentation<Attributes>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public AttributesBuilder removeAugmentation(Class<? extends Augmentation<Attributes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Attributes build() {
        return new AttributesImpl(this);
    }

    private static final class AttributesImpl
        extends AbstractAugmentable<Attributes>
        implements Attributes {
    
        private final Aggregator _aggregator;
        private final Aigp _aigp;
        private final AsPath _asPath;
        private final AtomicAggregate _atomicAggregate;
        private final BgpPrefixSid _bgpPrefixSid;
        private final CNextHop _cNextHop;
        private final ClusterId _clusterId;
        private final List<Communities> _communities;
        private final List<ExtendedCommunities> _extendedCommunities;
        private final LocalPref _localPref;
        private final MultiExitDisc _multiExitDisc;
        private final Origin _origin;
        private final OriginatorId _originatorId;
        private final Map<UnrecognizedAttributesKey, UnrecognizedAttributes> _unrecognizedAttributes;
    
        AttributesImpl(AttributesBuilder base) {
            super(base.augmentation);
            this._aggregator = base.getAggregator();
            this._aigp = base.getAigp();
            this._asPath = base.getAsPath();
            this._atomicAggregate = base.getAtomicAggregate();
            this._bgpPrefixSid = base.getBgpPrefixSid();
            this._cNextHop = base.getCNextHop();
            this._clusterId = base.getClusterId();
            this._communities = CodeHelpers.emptyToNull(base.getCommunities());
            this._extendedCommunities = CodeHelpers.emptyToNull(base.getExtendedCommunities());
            this._localPref = base.getLocalPref();
            this._multiExitDisc = base.getMultiExitDisc();
            this._origin = base.getOrigin();
            this._originatorId = base.getOriginatorId();
            this._unrecognizedAttributes = CodeHelpers.emptyToNull(base.getUnrecognizedAttributes());
        }
    
        @Override
        public Aggregator getAggregator() {
            return _aggregator;
        }
        
        @Override
        public Aigp getAigp() {
            return _aigp;
        }
        
        @Override
        public AsPath getAsPath() {
            return _asPath;
        }
        
        @Override
        public AtomicAggregate getAtomicAggregate() {
            return _atomicAggregate;
        }
        
        @Override
        public BgpPrefixSid getBgpPrefixSid() {
            return _bgpPrefixSid;
        }
        
        @Override
        public CNextHop getCNextHop() {
            return _cNextHop;
        }
        
        @Override
        public ClusterId getClusterId() {
            return _clusterId;
        }
        
        @Override
        public List<Communities> getCommunities() {
            return _communities;
        }
        
        @Override
        public List<ExtendedCommunities> getExtendedCommunities() {
            return _extendedCommunities;
        }
        
        @Override
        public LocalPref getLocalPref() {
            return _localPref;
        }
        
        @Override
        public MultiExitDisc getMultiExitDisc() {
            return _multiExitDisc;
        }
        
        @Override
        public Origin getOrigin() {
            return _origin;
        }
        
        @Override
        public OriginatorId getOriginatorId() {
            return _originatorId;
        }
        
        @Override
        public Map<UnrecognizedAttributesKey, UnrecognizedAttributes> getUnrecognizedAttributes() {
            return _unrecognizedAttributes;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Attributes.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Attributes.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Attributes.bindingToString(this);
        }
    }
}
