package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.BgpAggregator;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Aggregator} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Aggregator createAggregator(int fooXyzzy, int barBaz) {
 *         return new AggregatorBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Aggregator, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Aggregator
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class AggregatorBuilder implements Builder<Aggregator> {

    private AsNumber _asNumber;
    private Ipv4AddressNoZone _networkAddress;


    Map<Class<? extends Augmentation<Aggregator>>, Augmentation<Aggregator>> augmentation = Collections.emptyMap();

    public AggregatorBuilder() {
    }
    
    
    
    public AggregatorBuilder(BgpAggregator arg) {
        this._asNumber = arg.getAsNumber();
        this._networkAddress = arg.getNetworkAddress();
    }

    public AggregatorBuilder(Aggregator base) {
        Map<Class<? extends Augmentation<Aggregator>>, Augmentation<Aggregator>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._asNumber = base.getAsNumber();
        this._networkAddress = base.getNetworkAddress();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>BgpAggregator</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BgpAggregator) {
            this._asNumber = ((BgpAggregator)arg).getAsNumber();
            this._networkAddress = ((BgpAggregator)arg).getNetworkAddress();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[BgpAggregator]");
    }

    public AsNumber getAsNumber() {
        return _asNumber;
    }
    
    public Ipv4AddressNoZone getNetworkAddress() {
        return _networkAddress;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Aggregator>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public AggregatorBuilder setAsNumber(final AsNumber value) {
        this._asNumber = value;
        return this;
    }
    
    public AggregatorBuilder setNetworkAddress(final Ipv4AddressNoZone value) {
        this._networkAddress = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public AggregatorBuilder addAugmentation(Augmentation<Aggregator> augmentation) {
        Class<? extends Augmentation<Aggregator>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public AggregatorBuilder removeAugmentation(Class<? extends Augmentation<Aggregator>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Aggregator build() {
        return new AggregatorImpl(this);
    }

    private static final class AggregatorImpl
        extends AbstractAugmentable<Aggregator>
        implements Aggregator {
    
        private final AsNumber _asNumber;
        private final Ipv4AddressNoZone _networkAddress;
    
        AggregatorImpl(AggregatorBuilder base) {
            super(base.augmentation);
            this._asNumber = base.getAsNumber();
            this._networkAddress = base.getNetworkAddress();
        }
    
        @Override
        public AsNumber getAsNumber() {
            return _asNumber;
        }
        
        @Override
        public Ipv4AddressNoZone getNetworkAddress() {
            return _networkAddress;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Aggregator.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Aggregator.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Aggregator.bindingToString(this);
        }
    }
}
