package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.bgp.prefix.sid.BgpPrefixSidTlvs;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

/**
 * Class that builds {@link BgpPrefixSid} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     BgpPrefixSid createBgpPrefixSid(int fooXyzzy, int barBaz) {
 *         return new BgpPrefixSidBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of BgpPrefixSid, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see BgpPrefixSid
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class BgpPrefixSidBuilder implements Builder<BgpPrefixSid> {

    private List<BgpPrefixSidTlvs> _bgpPrefixSidTlvs;


    Map<Class<? extends Augmentation<BgpPrefixSid>>, Augmentation<BgpPrefixSid>> augmentation = Collections.emptyMap();

    public BgpPrefixSidBuilder() {
    }
    
    

    public BgpPrefixSidBuilder(BgpPrefixSid base) {
        Map<Class<? extends Augmentation<BgpPrefixSid>>, Augmentation<BgpPrefixSid>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._bgpPrefixSidTlvs = base.getBgpPrefixSidTlvs();
    }


    public List<BgpPrefixSidTlvs> getBgpPrefixSidTlvs() {
        return _bgpPrefixSidTlvs;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<BgpPrefixSid>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public BgpPrefixSidBuilder setBgpPrefixSidTlvs(final List<BgpPrefixSidTlvs> values) {
        this._bgpPrefixSidTlvs = values;
        return this;
    }
    
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public BgpPrefixSidBuilder addAugmentation(Augmentation<BgpPrefixSid> augmentation) {
        Class<? extends Augmentation<BgpPrefixSid>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public BgpPrefixSidBuilder removeAugmentation(Class<? extends Augmentation<BgpPrefixSid>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public BgpPrefixSid build() {
        return new BgpPrefixSidImpl(this);
    }

    private static final class BgpPrefixSidImpl
        extends AbstractAugmentable<BgpPrefixSid>
        implements BgpPrefixSid {
    
        private final List<BgpPrefixSidTlvs> _bgpPrefixSidTlvs;
    
        BgpPrefixSidImpl(BgpPrefixSidBuilder base) {
            super(base.augmentation);
            this._bgpPrefixSidTlvs = CodeHelpers.emptyToNull(base.getBgpPrefixSidTlvs());
        }
    
        @Override
        public List<BgpPrefixSidTlvs> getBgpPrefixSidTlvs() {
            return _bgpPrefixSidTlvs;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = BgpPrefixSid.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return BgpPrefixSid.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return BgpPrefixSid.bindingToString(this);
        }
    }
}
