package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.ExtendedCommunity;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link ExtendedCommunities} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ExtendedCommunities createExtendedCommunities(int fooXyzzy, int barBaz) {
 *         return new ExtendedCommunitiesBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ExtendedCommunities, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ExtendedCommunities
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class ExtendedCommunitiesBuilder implements Builder<ExtendedCommunities> {

    private ExtendedCommunity _extendedCommunity;
    private Boolean _transitive;


    Map<Class<? extends Augmentation<ExtendedCommunities>>, Augmentation<ExtendedCommunities>> augmentation = Collections.emptyMap();

    public ExtendedCommunitiesBuilder() {
    }
    
    
    
    public ExtendedCommunitiesBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ExtendedCommunity arg) {
        this._transitive = arg.getTransitive();
        this._extendedCommunity = arg.getExtendedCommunity();
    }

    public ExtendedCommunitiesBuilder(ExtendedCommunities base) {
        Map<Class<? extends Augmentation<ExtendedCommunities>>, Augmentation<ExtendedCommunities>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._extendedCommunity = base.getExtendedCommunity();
        this._transitive = base.getTransitive();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ExtendedCommunity</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ExtendedCommunity) {
            this._transitive = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ExtendedCommunity)arg).getTransitive();
            this._extendedCommunity = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ExtendedCommunity)arg).getExtendedCommunity();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ExtendedCommunity]");
    }

    public ExtendedCommunity getExtendedCommunity() {
        return _extendedCommunity;
    }
    
    public Boolean getTransitive() {
        return _transitive;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ExtendedCommunities>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public ExtendedCommunitiesBuilder setExtendedCommunity(final ExtendedCommunity value) {
        this._extendedCommunity = value;
        return this;
    }
    
    public ExtendedCommunitiesBuilder setTransitive(final Boolean value) {
        this._transitive = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ExtendedCommunitiesBuilder addAugmentation(Augmentation<ExtendedCommunities> augmentation) {
        Class<? extends Augmentation<ExtendedCommunities>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ExtendedCommunitiesBuilder removeAugmentation(Class<? extends Augmentation<ExtendedCommunities>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ExtendedCommunities build() {
        return new ExtendedCommunitiesImpl(this);
    }

    private static final class ExtendedCommunitiesImpl
        extends AbstractAugmentable<ExtendedCommunities>
        implements ExtendedCommunities {
    
        private final ExtendedCommunity _extendedCommunity;
        private final Boolean _transitive;
    
        ExtendedCommunitiesImpl(ExtendedCommunitiesBuilder base) {
            super(base.augmentation);
            this._extendedCommunity = base.getExtendedCommunity();
            this._transitive = base.getTransitive();
        }
    
        @Override
        public ExtendedCommunity getExtendedCommunity() {
            return _extendedCommunity;
        }
        
        @Override
        public Boolean getTransitive() {
            return _transitive;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = ExtendedCommunities.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return ExtendedCommunities.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return ExtendedCommunities.bindingToString(this);
        }
    }
}
