package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-message</b>
 * <pre>
 * list unrecognized-attributes {
 *   key type;
 *   leaf partial {
 *     type boolean;
 *   }
 *   leaf transitive {
 *     type boolean;
 *   }
 *   leaf type {
 *     type uint8;
 *   }
 *   leaf value {
 *     type binary {
 *       length 0..65535;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-messagepath-attributesattributesunrecognized-attributes</i>
 *
 * <p>To create instances of this class use {@link UnrecognizedAttributesBuilder}.
 * @see UnrecognizedAttributesBuilder
 * @see UnrecognizedAttributesKey
 *
 */
@Generated("mdsal-binding-generator")
public interface UnrecognizedAttributes
    extends
    ChildOf<Attributes>,
    Augmentable<UnrecognizedAttributes>,
    Identifiable<UnrecognizedAttributesKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("unrecognized-attributes");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.UnrecognizedAttributes> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.UnrecognizedAttributes.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.@NonNull UnrecognizedAttributes obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getPartial());
        result = prime * result + Objects.hashCode(obj.getTransitive());
        result = prime * result + Objects.hashCode(obj.getType());
        result = prime * result + Arrays.hashCode(obj.getValue());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.@NonNull UnrecognizedAttributes thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.UnrecognizedAttributes other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.UnrecognizedAttributes.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getPartial(), other.getPartial())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTransitive(), other.getTransitive())) {
            return false;
        }
        if (!Objects.equals(thisObj.getType(), other.getType())) {
            return false;
        }
        if (!Arrays.equals(thisObj.getValue(), other.getValue())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.@NonNull UnrecognizedAttributes obj) {
        final var helper = MoreObjects.toStringHelper("UnrecognizedAttributes");
        CodeHelpers.appendValue(helper, "partial", obj.getPartial());
        CodeHelpers.appendValue(helper, "transitive", obj.getTransitive());
        CodeHelpers.appendValue(helper, "type", obj.getType());
        CodeHelpers.appendValue(helper, "value", obj.getValue());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    UnrecognizedAttributesKey key();
    
    /**
     * Return partial, or {@code null} if it is not present.
     *
     * @return {@code Boolean} partial, or {@code null} if it is not present.
     *
     */
    Boolean getPartial();
    
    /**
     * Return partial, guaranteed to be non-null.
     *
     * @return {@code Boolean} partial, guaranteed to be non-null.
     * @throws NoSuchElementException if partial is not present
     *
     */
    default @NonNull Boolean requirePartial() {
        return CodeHelpers.require(getPartial(), "partial");
    }
    
    /**
     * Return transitive, or {@code null} if it is not present.
     *
     * @return {@code Boolean} transitive, or {@code null} if it is not present.
     *
     */
    Boolean getTransitive();
    
    /**
     * Return transitive, guaranteed to be non-null.
     *
     * @return {@code Boolean} transitive, guaranteed to be non-null.
     * @throws NoSuchElementException if transitive is not present
     *
     */
    default @NonNull Boolean requireTransitive() {
        return CodeHelpers.require(getTransitive(), "transitive");
    }
    
    /**
     * Return type, or {@code null} if it is not present.
     *
     * @return {@code Uint8} type, or {@code null} if it is not present.
     *
     */
    Uint8 getType();
    
    /**
     * Return type, guaranteed to be non-null.
     *
     * @return {@code Uint8} type, guaranteed to be non-null.
     * @throws NoSuchElementException if type is not present
     *
     */
    default @NonNull Uint8 requireType() {
        return CodeHelpers.require(getType(), "type");
    }
    
    /**
     * Return value, or {@code null} if it is not present.
     *
     * @return {@code byte[]} value, or {@code null} if it is not present.
     *
     */
    byte[] getValue();
    
    /**
     * Return value, guaranteed to be non-null.
     *
     * @return {@code byte[]} value, guaranteed to be non-null.
     * @throws NoSuchElementException if value is not present
     *
     */
    default byte @NonNull[] requireValue() {
        return CodeHelpers.require(getValue(), "value");
    }

}

