package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link UnrecognizedAttributes} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     UnrecognizedAttributes createUnrecognizedAttributes(int fooXyzzy, int barBaz) {
 *         return new UnrecognizedAttributesBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of UnrecognizedAttributes, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see UnrecognizedAttributes
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class UnrecognizedAttributesBuilder implements Builder<UnrecognizedAttributes> {

    private Boolean _partial;
    private Boolean _transitive;
    private Uint8 _type;
    private byte[] _value;
    private UnrecognizedAttributesKey key;


    Map<Class<? extends Augmentation<UnrecognizedAttributes>>, Augmentation<UnrecognizedAttributes>> augmentation = Collections.emptyMap();

    public UnrecognizedAttributesBuilder() {
    }
    
    
    

    public UnrecognizedAttributesBuilder(UnrecognizedAttributes base) {
        Map<Class<? extends Augmentation<UnrecognizedAttributes>>, Augmentation<UnrecognizedAttributes>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._type = base.getType();
        this._partial = base.getPartial();
        this._transitive = base.getTransitive();
        this._value = base.getValue();
    }


    public UnrecognizedAttributesKey key() {
        return key;
    }
    
    public Boolean getPartial() {
        return _partial;
    }
    
    public Boolean getTransitive() {
        return _transitive;
    }
    
    public Uint8 getType() {
        return _type;
    }
    
    public byte[] getValue() {
        return _value == null ? null : _value.clone();
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<UnrecognizedAttributes>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public UnrecognizedAttributesBuilder withKey(final UnrecognizedAttributesKey key) {
        this.key = key;
        return this;
    }
    
    public UnrecognizedAttributesBuilder setPartial(final Boolean value) {
        this._partial = value;
        return this;
    }
    
    public UnrecognizedAttributesBuilder setTransitive(final Boolean value) {
        this._transitive = value;
        return this;
    }
    
    public UnrecognizedAttributesBuilder setType(final Uint8 value) {
        this._type = value;
        return this;
    }
    
    private static void check_valueLength(final byte[] value) {
        final int length = value.length;
        if (length <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidLength("[[0..65535]]", value);
    }
    
    public UnrecognizedAttributesBuilder setValue(final byte[] value) {
        if (value != null) {
            check_valueLength(value);
            
        }
        this._value = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public UnrecognizedAttributesBuilder addAugmentation(Augmentation<UnrecognizedAttributes> augmentation) {
        Class<? extends Augmentation<UnrecognizedAttributes>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public UnrecognizedAttributesBuilder removeAugmentation(Class<? extends Augmentation<UnrecognizedAttributes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public UnrecognizedAttributes build() {
        return new UnrecognizedAttributesImpl(this);
    }

    private static final class UnrecognizedAttributesImpl
        extends AbstractAugmentable<UnrecognizedAttributes>
        implements UnrecognizedAttributes {
    
        private final Boolean _partial;
        private final Boolean _transitive;
        private final Uint8 _type;
        private final byte[] _value;
        private final UnrecognizedAttributesKey key;
    
        UnrecognizedAttributesImpl(UnrecognizedAttributesBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new UnrecognizedAttributesKey(base.getType());
            }
            this._type = key.getType();
            this._partial = base.getPartial();
            this._transitive = base.getTransitive();
            this._value = base.getValue();
        }
    
        @Override
        public UnrecognizedAttributesKey key() {
            return key;
        }
        
        @Override
        public Boolean getPartial() {
            return _partial;
        }
        
        @Override
        public Boolean getTransitive() {
            return _transitive;
        }
        
        @Override
        public Uint8 getType() {
            return _type;
        }
        
        @Override
        public byte[] getValue() {
            return _value == null ? null : _value.clone();
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = UnrecognizedAttributes.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return UnrecognizedAttributes.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return UnrecognizedAttributes.bindingToString(this);
        }
    }
}
