package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.unreach.MpUnreachNlri;
import org.opendaylight.yangtools.concepts.Builder;

/**
 * Class that builds {@link AttributesUnreach} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     AttributesUnreach createAttributesUnreach(int fooXyzzy, int barBaz) {
 *         return new AttributesUnreachBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of AttributesUnreach, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see AttributesUnreach
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class AttributesUnreachBuilder implements Builder<AttributesUnreach> {

    private MpUnreachNlri _mpUnreachNlri;



    public AttributesUnreachBuilder() {
    }
    

    public AttributesUnreachBuilder(AttributesUnreach base) {
        this._mpUnreachNlri = base.getMpUnreachNlri();
    }


    public MpUnreachNlri getMpUnreachNlri() {
        return _mpUnreachNlri;
    }

    
    public AttributesUnreachBuilder setMpUnreachNlri(final MpUnreachNlri value) {
        this._mpUnreachNlri = value;
        return this;
    }
    

    @Override
    public AttributesUnreach build() {
        return new AttributesUnreachImpl(this);
    }

    private static final class AttributesUnreachImpl
        implements AttributesUnreach {
    
        private final MpUnreachNlri _mpUnreachNlri;
    
        AttributesUnreachImpl(AttributesUnreachBuilder base) {
            this._mpUnreachNlri = base.getMpUnreachNlri();
        }
    
        @Override
        public MpUnreachNlri getMpUnreachNlri() {
            return _mpUnreachNlri;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = AttributesUnreach.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return AttributesUnreach.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return AttributesUnreach.bindingToString(this);
        }
    }
}
