package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-multiprotocol</b>
 * <pre>
 * grouping bgp-table-type {
 *   leaf afi {
 *     type identityref {
 *       base address-family;
 *     }
 *   }
 *   leaf safi {
 *     type identityref {
 *       base subsequent-address-family;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-multiprotocolbgp-table-type</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface BgpTableType
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("bgp-table-type");

    @Override
    Class<? extends BgpTableType> implementedInterface();
    
    /**
     * Return afi, or {@code null} if it is not present.
     *
     * @return {@code Class<? extends AddressFamily>} afi, or {@code null} if it is not present.
     *
     */
    Class<? extends AddressFamily> getAfi();
    
    /**
     * Return afi, guaranteed to be non-null.
     *
     * @return {@code Class<? extends AddressFamily>} afi, guaranteed to be non-null.
     * @throws NoSuchElementException if afi is not present
     *
     */
    default @NonNull Class<? extends AddressFamily> requireAfi() {
        return CodeHelpers.require(getAfi(), "afi");
    }
    
    /**
     * Return safi, or {@code null} if it is not present.
     *
     * @return {@code Class<? extends SubsequentAddressFamily>} safi, or {@code null} if it is not present.
     *
     */
    Class<? extends SubsequentAddressFamily> getSafi();
    
    /**
     * Return safi, guaranteed to be non-null.
     *
     * @return {@code Class<? extends SubsequentAddressFamily>} safi, guaranteed to be non-null.
     * @throws NoSuchElementException if safi is not present
     *
     */
    default @NonNull Class<? extends SubsequentAddressFamily> requireSafi() {
        return CodeHelpers.require(getSafi(), "safi");
    }

}

