package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.reach;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.reach.mp.reach.nlri.AdvertizedRoutes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.NextHop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.CNextHop;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link MpReachNlri} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     MpReachNlri createMpReachNlri(int fooXyzzy, int barBaz) {
 *         return new MpReachNlriBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of MpReachNlri, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see MpReachNlri
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class MpReachNlriBuilder implements Builder<MpReachNlri> {

    private AdvertizedRoutes _advertizedRoutes;
    private Class<? extends AddressFamily> _afi;
    private CNextHop _cNextHop;
    private Class<? extends SubsequentAddressFamily> _safi;


    Map<Class<? extends Augmentation<MpReachNlri>>, Augmentation<MpReachNlri>> augmentation = Collections.emptyMap();

    public MpReachNlriBuilder() {
    }
    
    
    
    public MpReachNlriBuilder(BgpTableType arg) {
        this._afi = arg.getAfi();
        this._safi = arg.getSafi();
    }
    
    public MpReachNlriBuilder(NextHop arg) {
        this._cNextHop = arg.getCNextHop();
    }

    public MpReachNlriBuilder(MpReachNlri base) {
        Map<Class<? extends Augmentation<MpReachNlri>>, Augmentation<MpReachNlri>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._advertizedRoutes = base.getAdvertizedRoutes();
        this._afi = base.getAfi();
        this._cNextHop = base.getCNextHop();
        this._safi = base.getSafi();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>NextHop</li>
     * <li>BgpTableType</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NextHop) {
            this._cNextHop = ((NextHop)arg).getCNextHop();
            isValidArg = true;
        }
        if (arg instanceof BgpTableType) {
            this._afi = ((BgpTableType)arg).getAfi();
            this._safi = ((BgpTableType)arg).getSafi();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[NextHop, BgpTableType]");
    }

    public AdvertizedRoutes getAdvertizedRoutes() {
        return _advertizedRoutes;
    }
    
    public Class<? extends AddressFamily> getAfi() {
        return _afi;
    }
    
    public CNextHop getCNextHop() {
        return _cNextHop;
    }
    
    public Class<? extends SubsequentAddressFamily> getSafi() {
        return _safi;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<MpReachNlri>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public MpReachNlriBuilder setAdvertizedRoutes(final AdvertizedRoutes value) {
        this._advertizedRoutes = value;
        return this;
    }
    
    public MpReachNlriBuilder setAfi(final Class<? extends AddressFamily> value) {
        this._afi = value;
        return this;
    }
    
    public MpReachNlriBuilder setCNextHop(final CNextHop value) {
        this._cNextHop = value;
        return this;
    }
    
    public MpReachNlriBuilder setSafi(final Class<? extends SubsequentAddressFamily> value) {
        this._safi = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public MpReachNlriBuilder addAugmentation(Augmentation<MpReachNlri> augmentation) {
        Class<? extends Augmentation<MpReachNlri>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public MpReachNlriBuilder removeAugmentation(Class<? extends Augmentation<MpReachNlri>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public MpReachNlri build() {
        return new MpReachNlriImpl(this);
    }

    private static final class MpReachNlriImpl
        extends AbstractAugmentable<MpReachNlri>
        implements MpReachNlri {
    
        private final AdvertizedRoutes _advertizedRoutes;
        private final Class<? extends AddressFamily> _afi;
        private final CNextHop _cNextHop;
        private final Class<? extends SubsequentAddressFamily> _safi;
    
        MpReachNlriImpl(MpReachNlriBuilder base) {
            super(base.augmentation);
            this._advertizedRoutes = base.getAdvertizedRoutes();
            this._afi = base.getAfi();
            this._cNextHop = base.getCNextHop();
            this._safi = base.getSafi();
        }
    
        @Override
        public AdvertizedRoutes getAdvertizedRoutes() {
            return _advertizedRoutes;
        }
        
        @Override
        public Class<? extends AddressFamily> getAfi() {
            return _afi;
        }
        
        @Override
        public CNextHop getCNextHop() {
            return _cNextHop;
        }
        
        @Override
        public Class<? extends SubsequentAddressFamily> getSafi() {
            return _safi;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = MpReachNlri.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return MpReachNlri.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return MpReachNlri.bindingToString(this);
        }
    }
}
