package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.add.path.capability.AddressFamilies;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

/**
 * Class that builds {@link AddPathCapability} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     AddPathCapability createAddPathCapability(int fooXyzzy, int barBaz) {
 *         return new AddPathCapabilityBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of AddPathCapability, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see AddPathCapability
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class AddPathCapabilityBuilder implements Builder<AddPathCapability> {

    private List<AddressFamilies> _addressFamilies;


    Map<Class<? extends Augmentation<AddPathCapability>>, Augmentation<AddPathCapability>> augmentation = Collections.emptyMap();

    public AddPathCapabilityBuilder() {
    }
    
    

    public AddPathCapabilityBuilder(AddPathCapability base) {
        Map<Class<? extends Augmentation<AddPathCapability>>, Augmentation<AddPathCapability>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._addressFamilies = base.getAddressFamilies();
    }


    public List<AddressFamilies> getAddressFamilies() {
        return _addressFamilies;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<AddPathCapability>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public AddPathCapabilityBuilder setAddressFamilies(final List<AddressFamilies> values) {
        this._addressFamilies = values;
        return this;
    }
    
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public AddPathCapabilityBuilder addAugmentation(Augmentation<AddPathCapability> augmentation) {
        Class<? extends Augmentation<AddPathCapability>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public AddPathCapabilityBuilder removeAugmentation(Class<? extends Augmentation<AddPathCapability>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public AddPathCapability build() {
        return new AddPathCapabilityImpl(this);
    }

    private static final class AddPathCapabilityImpl
        extends AbstractAugmentable<AddPathCapability>
        implements AddPathCapability {
    
        private final List<AddressFamilies> _addressFamilies;
    
        AddPathCapabilityImpl(AddPathCapabilityBuilder base) {
            super(base.augmentation);
            this._addressFamilies = CodeHelpers.emptyToNull(base.getAddressFamilies());
        }
    
        @Override
        public List<AddressFamilies> getAddressFamilies() {
            return _addressFamilies;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = AddPathCapability.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return AddPathCapability.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return AddPathCapability.bindingToString(this);
        }
    }
}
