package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.MpCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.graceful.restart.capability.Tables;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.graceful.restart.capability.TablesKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-multiprotocol</b>
 * <pre>
 * container graceful-restart-capability {
 *   presence "indicates a graceful restart capability";
 *   leaf restart-flags {
 *     type bits {
 *       bit restart-state {
 *         position 0;
 *       }
 *     }
 *   }
 *   leaf restart-time {
 *     type uint16 {
 *       range 0..4095;
 *     }
 *     units seconds;
 *     default 0;
 *   }
 *   list tables {
 *     uses bgp-table-type;
 *     key "afi safi";
 *     leaf afi-flags {
 *       type bits {
 *         bit forwarding-state {
 *           position 0;
 *         }
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-multiprotocolmp-capabilitiesgraceful-restart-capability</i>
 *
 * <p>To create instances of this class use {@link GracefulRestartCapabilityBuilder}.
 * @see GracefulRestartCapabilityBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface GracefulRestartCapability
    extends
    ChildOf<MpCapabilities>,
    Augmentable<GracefulRestartCapability>
{

    public static final class RestartFlags
     implements TypeObject, Serializable {
        private static final long serialVersionUID = 324929273417501826L;
        private final Boolean _restartState;
    
    
        public RestartFlags(Boolean _restartState) {
        
            this._restartState = _restartState;
        }
        
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public RestartFlags(RestartFlags source) {
            this._restartState = source._restartState;
        }
    
    
        public Boolean getRestartState() {
            return _restartState;
        }
    
    
        @Override
        public int hashCode() {
            return CodeHelpers.wrapperHashCode(_restartState);
        }
    
        @Override
        public final boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RestartFlags)) {
                return false;
            }
            final RestartFlags other = (RestartFlags) obj;
            if (!Objects.equals(_restartState, other._restartState)) {
                return false;
            }
            return true;
        }
    
        @Override
        public String toString() {
            final var helper = MoreObjects.toStringHelper(RestartFlags.class);
            CodeHelpers.appendValue(helper, "_restartState", _restartState);
            return helper.toString();
        }
    }
    


    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("graceful-restart-capability");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.GracefulRestartCapability> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.GracefulRestartCapability.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.@NonNull GracefulRestartCapability obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getRestartFlags());
        result = prime * result + Objects.hashCode(obj.getRestartTime());
        result = prime * result + Objects.hashCode(obj.getTables());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.@NonNull GracefulRestartCapability thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.GracefulRestartCapability other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.GracefulRestartCapability.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getRestartTime(), other.getRestartTime())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRestartFlags(), other.getRestartFlags())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTables(), other.getTables())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.@NonNull GracefulRestartCapability obj) {
        final var helper = MoreObjects.toStringHelper("GracefulRestartCapability");
        CodeHelpers.appendValue(helper, "restartFlags", obj.getRestartFlags());
        CodeHelpers.appendValue(helper, "restartTime", obj.getRestartTime());
        CodeHelpers.appendValue(helper, "tables", obj.getTables());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return restartFlags, or {@code null} if it is not present.
     *
     * @return {@code RestartFlags} restartFlags, or {@code null} if it is not present.
     *
     */
    RestartFlags getRestartFlags();
    
    /**
     * Return restartFlags, guaranteed to be non-null.
     *
     * @return {@code RestartFlags} restartFlags, guaranteed to be non-null.
     * @throws NoSuchElementException if restartFlags is not present
     *
     */
    default @NonNull RestartFlags requireRestartFlags() {
        return CodeHelpers.require(getRestartFlags(), "restartflags");
    }
    
    /**
     * Return restartTime, or {@code null} if it is not present.
     *
     * @return {@code Uint16} restartTime, or {@code null} if it is not present.
     *
     */
    Uint16 getRestartTime();
    
    /**
     * Return restartTime, guaranteed to be non-null.
     *
     * @return {@code Uint16} restartTime, guaranteed to be non-null.
     * @throws NoSuchElementException if restartTime is not present
     *
     */
    default @NonNull Uint16 requireRestartTime() {
        return CodeHelpers.require(getRestartTime(), "restarttime");
    }
    
    /**
     * Return tables, or {@code null} if it is not present.
     *
     * @return {@code Map<TablesKey, Tables>} tables, or {@code null} if it is not present.
     *
     */
    @Nullable Map<TablesKey, Tables> getTables();
    
    /**
     * Return tables, or an empty list if it is not present.
     *
     * @return {@code Map<TablesKey, Tables>} tables, or an empty list if it is not present.
     *
     */
    default @NonNull Map<TablesKey, Tables> nonnullTables() {
        return CodeHelpers.nonnull(getTables());
    }

}

