package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.graceful.restart.capability;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

@Generated("mdsal-binding-generator")
public class TablesKey
 implements Identifier<Tables> {
    private static final long serialVersionUID = 7040661022102848903L;
    private final Class<? extends AddressFamily> _afi;
    private final Class<? extends SubsequentAddressFamily> _safi;


    public TablesKey(@NonNull Class<? extends AddressFamily> _afi, @NonNull Class<? extends SubsequentAddressFamily> _safi) {
        this._afi = CodeHelpers.requireKeyProp(_afi, "afi");
        this._safi = CodeHelpers.requireKeyProp(_safi, "safi");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public TablesKey(TablesKey source) {
        this._afi = source._afi;
        this._safi = source._safi;
    }


    public @NonNull Class<? extends AddressFamily> getAfi() {
        return _afi;
    }
    
    public @NonNull Class<? extends SubsequentAddressFamily> getSafi() {
        return _safi;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_afi);
        result = prime * result + Objects.hashCode(_safi);
        return result;
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TablesKey)) {
            return false;
        }
        final TablesKey other = (TablesKey) obj;
        if (!Objects.equals(_afi, other._afi)) {
            return false;
        }
        if (!Objects.equals(_safi, other._safi)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(TablesKey.class);
        CodeHelpers.appendValue(helper, "_afi", _afi);
        CodeHelpers.appendValue(helper, "_safi", _safi);
        return helper.toString();
    }
}

