package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.routing.types.rev171204.Uint24;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.LlGracefulRestartCapability;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-multiprotocol</b>
 * <pre>
 * list tables {
 *   uses bgp-table-type;
 *   key "afi safi";
 *   leaf afi-flags {
 *     type bits {
 *       bit forwarding-state {
 *         position 0;
 *       }
 *     }
 *   }
 *   leaf long-lived-stale-time {
 *     type rt-types:uint24;
 *     units seconds;
 *     default 0;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-multiprotocolmp-capabilitiesll-graceful-restart-capabilitytables</i>
 *
 * <p>To create instances of this class use {@link TablesBuilder}.
 * @see TablesBuilder
 * @see TablesKey
 *
 */
@Generated("mdsal-binding-generator")
public interface Tables
    extends
    ChildOf<LlGracefulRestartCapability>,
    Augmentable<Tables>,
    BgpTableType,
    Identifiable<TablesKey>
{

    public static final class AfiFlags
     implements TypeObject, Serializable {
        private static final long serialVersionUID = 8494451692068161343L;
        private final Boolean _forwardingState;
    
    
        public AfiFlags(Boolean _forwardingState) {
        
            this._forwardingState = _forwardingState;
        }
        
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public AfiFlags(AfiFlags source) {
            this._forwardingState = source._forwardingState;
        }
    
    
        public Boolean getForwardingState() {
            return _forwardingState;
        }
    
    
        @Override
        public int hashCode() {
            return CodeHelpers.wrapperHashCode(_forwardingState);
        }
    
        @Override
        public final boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AfiFlags)) {
                return false;
            }
            final AfiFlags other = (AfiFlags) obj;
            if (!Objects.equals(_forwardingState, other._forwardingState)) {
                return false;
            }
            return true;
        }
    
        @Override
        public String toString() {
            final var helper = MoreObjects.toStringHelper(AfiFlags.class);
            CodeHelpers.appendValue(helper, "_forwardingState", _forwardingState);
            return helper.toString();
        }
    }
    


    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("tables");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability.Tables> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability.Tables.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability.@NonNull Tables obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAfi());
        result = prime * result + Objects.hashCode(obj.getAfiFlags());
        result = prime * result + Objects.hashCode(obj.getLongLivedStaleTime());
        result = prime * result + Objects.hashCode(obj.getSafi());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability.@NonNull Tables thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability.Tables other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability.Tables.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getAfi(), other.getAfi())) {
            return false;
        }
        if (!Objects.equals(thisObj.getLongLivedStaleTime(), other.getLongLivedStaleTime())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSafi(), other.getSafi())) {
            return false;
        }
        if (!Objects.equals(thisObj.getAfiFlags(), other.getAfiFlags())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability.@NonNull Tables obj) {
        final var helper = MoreObjects.toStringHelper("Tables");
        CodeHelpers.appendValue(helper, "afi", obj.getAfi());
        CodeHelpers.appendValue(helper, "afiFlags", obj.getAfiFlags());
        CodeHelpers.appendValue(helper, "longLivedStaleTime", obj.getLongLivedStaleTime());
        CodeHelpers.appendValue(helper, "safi", obj.getSafi());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    TablesKey key();
    
    /**
     * Return afiFlags, or {@code null} if it is not present.
     *
     * @return {@code AfiFlags} afiFlags, or {@code null} if it is not present.
     *
     */
    AfiFlags getAfiFlags();
    
    /**
     * Return afiFlags, guaranteed to be non-null.
     *
     * @return {@code AfiFlags} afiFlags, guaranteed to be non-null.
     * @throws NoSuchElementException if afiFlags is not present
     *
     */
    default @NonNull AfiFlags requireAfiFlags() {
        return CodeHelpers.require(getAfiFlags(), "afiflags");
    }
    
    /**
     * Return longLivedStaleTime, or {@code null} if it is not present.
     *
     * @return {@code Uint24} longLivedStaleTime, or {@code null} if it is not present.
     *
     */
    Uint24 getLongLivedStaleTime();
    
    /**
     * Return longLivedStaleTime, guaranteed to be non-null.
     *
     * @return {@code Uint24} longLivedStaleTime, guaranteed to be non-null.
     * @throws NoSuchElementException if longLivedStaleTime is not present
     *
     */
    default @NonNull Uint24 requireLongLivedStaleTime() {
        return CodeHelpers.require(getLongLivedStaleTime(), "longlivedstaletime");
    }

}

