/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.BgpParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.OptionalCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.c.parameters.As4BytesCapability;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;

public final class AsNumberUtil {
    private AsNumberUtil() {
    }

    public static @NonNull AsNumber advertizedAsNumber(Open open) {
        List params = open.getBgpParameters();
        if (params != null) {
            for (BgpParameters p : params) {
                for (OptionalCapabilities oc : p.nonnullOptionalCapabilities()) {
                    As4BytesCapability as4;
                    CParameters cparams = oc.getCParameters();
                    if (cparams == null || (as4 = cparams.getAs4BytesCapability()) == null) continue;
                    return as4.getAsNumber();
                }
            }
        }
        return new AsNumber(Uint32.valueOf((Uint16)open.getMyAsNumber()));
    }

    public static AsNumber extractAS(DataContainerNode dtc, YangInstanceIdentifier.NodeIdentifier nid) {
        NormalizedNode as = NormalizedNodes.findNode((NormalizedNode)dtc, (YangInstanceIdentifier.PathArgument)nid).orElse(null);
        if (as != null) {
            return new AsNumber((Uint32)as.body());
        }
        return null;
    }
}

