/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Aggregator;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.BgpAggregator;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AggregatorBuilder {
    private AsNumber _asNumber;
    private Ipv4AddressNoZone _networkAddress;
    Map<Class<? extends Augmentation<Aggregator>>, Augmentation<Aggregator>> augmentation = Map.of();

    public AggregatorBuilder() {
    }

    public AggregatorBuilder(BgpAggregator arg) {
        this._asNumber = arg.getAsNumber();
        this._networkAddress = arg.getNetworkAddress();
    }

    public AggregatorBuilder(Aggregator base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Aggregator>>, Augmentation<Aggregator>>(aug);
        }
        this._asNumber = base.getAsNumber();
        this._networkAddress = base.getNetworkAddress();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BgpAggregator) {
            this._asNumber = ((BgpAggregator)arg).getAsNumber();
            this._networkAddress = ((BgpAggregator)arg).getNetworkAddress();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[BgpAggregator]");
    }

    public AsNumber getAsNumber() {
        return this._asNumber;
    }

    public Ipv4AddressNoZone getNetworkAddress() {
        return this._networkAddress;
    }

    public <E$$ extends Augmentation<Aggregator>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public AggregatorBuilder setAsNumber(AsNumber value) {
        this._asNumber = value;
        return this;
    }

    public AggregatorBuilder setNetworkAddress(Ipv4AddressNoZone value) {
        this._networkAddress = value;
        return this;
    }

    public AggregatorBuilder addAugmentation(Augmentation<Aggregator> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Aggregator>>, Augmentation<Aggregator>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public AggregatorBuilder removeAugmentation(Class<? extends Augmentation<Aggregator>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Aggregator build() {
        return new AggregatorImpl(this);
    }

    private static final class AggregatorImpl
    extends AbstractAugmentable<Aggregator>
    implements Aggregator {
        private final AsNumber _asNumber;
        private final Ipv4AddressNoZone _networkAddress;
        private int hash = 0;
        private volatile boolean hashValid = false;

        AggregatorImpl(AggregatorBuilder base) {
            super(base.augmentation);
            this._asNumber = base.getAsNumber();
            this._networkAddress = base.getNetworkAddress();
        }

        public AsNumber getAsNumber() {
            return this._asNumber;
        }

        public Ipv4AddressNoZone getNetworkAddress() {
            return this._networkAddress;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Aggregator.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Aggregator.bindingEquals(this, obj);
        }

        public String toString() {
            return Aggregator.bindingToString(this);
        }
    }
}

