/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.reach;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.reach.MpReachNlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.reach.mp.reach.nlri.AdvertizedRoutes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.NextHop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.CNextHop;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MpReachNlriBuilder {
    private AdvertizedRoutes _advertizedRoutes;
    private Class<? extends AddressFamily> _afi;
    private CNextHop _cNextHop;
    private Class<? extends SubsequentAddressFamily> _safi;
    Map<Class<? extends Augmentation<MpReachNlri>>, Augmentation<MpReachNlri>> augmentation = Map.of();

    public MpReachNlriBuilder() {
    }

    public MpReachNlriBuilder(BgpTableType arg) {
        this._afi = arg.getAfi();
        this._safi = arg.getSafi();
    }

    public MpReachNlriBuilder(NextHop arg) {
        this._cNextHop = arg.getCNextHop();
    }

    public MpReachNlriBuilder(MpReachNlri base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MpReachNlri>>, Augmentation<MpReachNlri>>(aug);
        }
        this._advertizedRoutes = base.getAdvertizedRoutes();
        this._afi = base.getAfi();
        this._cNextHop = base.getCNextHop();
        this._safi = base.getSafi();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NextHop) {
            this._cNextHop = ((NextHop)arg).getCNextHop();
            isValidArg = true;
        }
        if (arg instanceof BgpTableType) {
            this._afi = ((BgpTableType)arg).getAfi();
            this._safi = ((BgpTableType)arg).getSafi();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[NextHop, BgpTableType]");
    }

    public AdvertizedRoutes getAdvertizedRoutes() {
        return this._advertizedRoutes;
    }

    public Class<? extends AddressFamily> getAfi() {
        return this._afi;
    }

    public CNextHop getCNextHop() {
        return this._cNextHop;
    }

    public Class<? extends SubsequentAddressFamily> getSafi() {
        return this._safi;
    }

    public <E$$ extends Augmentation<MpReachNlri>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public MpReachNlriBuilder setAdvertizedRoutes(AdvertizedRoutes value) {
        this._advertizedRoutes = value;
        return this;
    }

    public MpReachNlriBuilder setAfi(Class<? extends AddressFamily> value) {
        this._afi = value;
        return this;
    }

    public MpReachNlriBuilder setCNextHop(CNextHop value) {
        this._cNextHop = value;
        return this;
    }

    public MpReachNlriBuilder setSafi(Class<? extends SubsequentAddressFamily> value) {
        this._safi = value;
        return this;
    }

    public MpReachNlriBuilder addAugmentation(Augmentation<MpReachNlri> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MpReachNlri>>, Augmentation<MpReachNlri>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public MpReachNlriBuilder removeAugmentation(Class<? extends Augmentation<MpReachNlri>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull MpReachNlri build() {
        return new MpReachNlriImpl(this);
    }

    private static final class MpReachNlriImpl
    extends AbstractAugmentable<MpReachNlri>
    implements MpReachNlri {
        private final AdvertizedRoutes _advertizedRoutes;
        private final Class<? extends AddressFamily> _afi;
        private final CNextHop _cNextHop;
        private final Class<? extends SubsequentAddressFamily> _safi;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MpReachNlriImpl(MpReachNlriBuilder base) {
            super(base.augmentation);
            this._advertizedRoutes = base.getAdvertizedRoutes();
            this._afi = base.getAfi();
            this._cNextHop = base.getCNextHop();
            this._safi = base.getSafi();
        }

        @Override
        public AdvertizedRoutes getAdvertizedRoutes() {
            return this._advertizedRoutes;
        }

        @Override
        public Class<? extends AddressFamily> getAfi() {
            return this._afi;
        }

        public CNextHop getCNextHop() {
            return this._cNextHop;
        }

        @Override
        public Class<? extends SubsequentAddressFamily> getSafi() {
            return this._safi;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = MpReachNlri.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return MpReachNlri.bindingEquals(this, obj);
        }

        public String toString() {
            return MpReachNlri.bindingToString(this);
        }
    }
}

