/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.Update;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.UpdateMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.update.message.Nlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.update.message.WithdrawnRoutes;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class UpdateBuilder {
    private Attributes _attributes;
    private List<Nlri> _nlri;
    private List<WithdrawnRoutes> _withdrawnRoutes;
    Map<Class<? extends Augmentation<Update>>, Augmentation<Update>> augmentation = Map.of();

    public UpdateBuilder() {
    }

    public UpdateBuilder(UpdateMessage arg) {
        this._withdrawnRoutes = arg.getWithdrawnRoutes();
        this._nlri = arg.getNlri();
        this._attributes = arg.getAttributes();
    }

    public UpdateBuilder(PathAttributes arg) {
        this._attributes = arg.getAttributes();
    }

    public UpdateBuilder(Update base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Update>>, Augmentation<Update>>(aug);
        }
        this._attributes = base.getAttributes();
        this._nlri = base.getNlri();
        this._withdrawnRoutes = base.getWithdrawnRoutes();
    }

    public void fieldsFrom(DataObject arg) {
        PathAttributes castArg;
        boolean isValidArg = false;
        if (arg instanceof UpdateMessage) {
            castArg = (UpdateMessage)arg;
            this._withdrawnRoutes = castArg.getWithdrawnRoutes();
            this._nlri = castArg.getNlri();
            isValidArg = true;
        }
        if (arg instanceof PathAttributes) {
            castArg = (PathAttributes)arg;
            this._attributes = castArg.getAttributes();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[UpdateMessage, PathAttributes]");
    }

    public Attributes getAttributes() {
        return this._attributes;
    }

    public List<Nlri> getNlri() {
        return this._nlri;
    }

    public List<WithdrawnRoutes> getWithdrawnRoutes() {
        return this._withdrawnRoutes;
    }

    public <E$$ extends Augmentation<Update>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public UpdateBuilder setAttributes(Attributes value) {
        this._attributes = value;
        return this;
    }

    public UpdateBuilder setNlri(List<Nlri> values) {
        this._nlri = values;
        return this;
    }

    public UpdateBuilder setWithdrawnRoutes(List<WithdrawnRoutes> values) {
        this._withdrawnRoutes = values;
        return this;
    }

    public UpdateBuilder addAugmentation(Augmentation<Update> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Update>>, Augmentation<Update>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public UpdateBuilder removeAugmentation(Class<? extends Augmentation<Update>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Update build() {
        return new UpdateImpl(this);
    }

    private static final class UpdateImpl
    extends AbstractAugmentable<Update>
    implements Update {
        private final Attributes _attributes;
        private final List<Nlri> _nlri;
        private final List<WithdrawnRoutes> _withdrawnRoutes;
        private int hash = 0;
        private volatile boolean hashValid = false;

        UpdateImpl(UpdateBuilder base) {
            super(base.augmentation);
            this._attributes = base.getAttributes();
            this._nlri = CodeHelpers.emptyToNull(base.getNlri());
            this._withdrawnRoutes = CodeHelpers.emptyToNull(base.getWithdrawnRoutes());
        }

        @Override
        public Attributes getAttributes() {
            return this._attributes;
        }

        @Override
        public List<Nlri> getNlri() {
            return this._nlri;
        }

        @Override
        public List<WithdrawnRoutes> getWithdrawnRoutes() {
            return this._withdrawnRoutes;
        }

        @Override
        public Attributes nonnullAttributes() {
            return Objects.requireNonNullElse(this.getAttributes(), AttributesBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Update.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Update.bindingEquals(this, obj);
        }

        public String toString() {
            return Update.bindingToString(this);
        }
    }
}

