/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.update.message;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.Ipv4PrefixAndPathId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathIdGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.update.message.Nlri;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NlriBuilder {
    private PathId _pathId;
    private Ipv4Prefix _prefix;
    Map<Class<? extends Augmentation<Nlri>>, Augmentation<Nlri>> augmentation = Map.of();

    public NlriBuilder() {
    }

    public NlriBuilder(Ipv4PrefixAndPathId arg) {
        this._prefix = arg.getPrefix();
        this._pathId = arg.getPathId();
    }

    public NlriBuilder(PathIdGrouping arg) {
        this._pathId = arg.getPathId();
    }

    public NlriBuilder(Nlri base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Nlri>>, Augmentation<Nlri>>(aug);
        }
        this._pathId = base.getPathId();
        this._prefix = base.getPrefix();
    }

    public void fieldsFrom(DataObject arg) {
        PathIdGrouping castArg;
        boolean isValidArg = false;
        if (arg instanceof PathIdGrouping) {
            castArg = (PathIdGrouping)arg;
            this._pathId = castArg.getPathId();
            isValidArg = true;
        }
        if (arg instanceof Ipv4PrefixAndPathId) {
            castArg = (Ipv4PrefixAndPathId)arg;
            this._prefix = castArg.getPrefix();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[PathIdGrouping, Ipv4PrefixAndPathId]");
    }

    public PathId getPathId() {
        return this._pathId;
    }

    public Ipv4Prefix getPrefix() {
        return this._prefix;
    }

    public <E$$ extends Augmentation<Nlri>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public NlriBuilder setPathId(PathId value) {
        this._pathId = value;
        return this;
    }

    public NlriBuilder setPrefix(Ipv4Prefix value) {
        this._prefix = value;
        return this;
    }

    public NlriBuilder addAugmentation(Augmentation<Nlri> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Nlri>>, Augmentation<Nlri>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public NlriBuilder removeAugmentation(Class<? extends Augmentation<Nlri>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Nlri build() {
        return new NlriImpl(this);
    }

    private static final class NlriImpl
    extends AbstractAugmentable<Nlri>
    implements Nlri {
        private final PathId _pathId;
        private final Ipv4Prefix _prefix;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NlriImpl(NlriBuilder base) {
            super(base.augmentation);
            this._pathId = base.getPathId();
            this._prefix = base.getPrefix();
        }

        @Override
        public PathId getPathId() {
            return this._pathId;
        }

        @Override
        public Ipv4Prefix getPrefix() {
            return this._prefix;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Nlri.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Nlri.bindingEquals(this, obj);
        }

        public String toString() {
            return Nlri.bindingToString(this);
        }
    }
}

