/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.unreach;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.unreach.MpUnreachNlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.unreach.mp.unreach.nlri.WithdrawnRoutes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.unreach.mp.unreach.nlri.WithdrawnRoutesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MpUnreachNlriBuilder {
    private AddressFamily _afi;
    private SubsequentAddressFamily _safi;
    private WithdrawnRoutes _withdrawnRoutes;
    Map<Class<? extends Augmentation<MpUnreachNlri>>, Augmentation<MpUnreachNlri>> augmentation = Map.of();

    public MpUnreachNlriBuilder() {
    }

    public MpUnreachNlriBuilder(BgpTableType arg) {
        this._afi = arg.getAfi();
        this._safi = arg.getSafi();
    }

    public MpUnreachNlriBuilder(MpUnreachNlri base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MpUnreachNlri>>, Augmentation<MpUnreachNlri>>(aug);
        }
        this._afi = base.getAfi();
        this._safi = base.getSafi();
        this._withdrawnRoutes = base.getWithdrawnRoutes();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BgpTableType) {
            BgpTableType castArg = (BgpTableType)arg;
            this._afi = castArg.getAfi();
            this._safi = castArg.getSafi();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[BgpTableType]");
    }

    public static @NonNull MpUnreachNlri empty() {
        return LazyEmpty.INSTANCE;
    }

    public AddressFamily getAfi() {
        return this._afi;
    }

    public SubsequentAddressFamily getSafi() {
        return this._safi;
    }

    public WithdrawnRoutes getWithdrawnRoutes() {
        return this._withdrawnRoutes;
    }

    public <E$$ extends Augmentation<MpUnreachNlri>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public MpUnreachNlriBuilder setAfi(AddressFamily value) {
        this._afi = value;
        return this;
    }

    public MpUnreachNlriBuilder setSafi(SubsequentAddressFamily value) {
        this._safi = value;
        return this;
    }

    public MpUnreachNlriBuilder setWithdrawnRoutes(WithdrawnRoutes value) {
        this._withdrawnRoutes = value;
        return this;
    }

    public MpUnreachNlriBuilder addAugmentation(Augmentation<MpUnreachNlri> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MpUnreachNlri>>, Augmentation<MpUnreachNlri>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public MpUnreachNlriBuilder removeAugmentation(Class<? extends Augmentation<MpUnreachNlri>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull MpUnreachNlri build() {
        return new MpUnreachNlriImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull MpUnreachNlri INSTANCE = new MpUnreachNlriBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class MpUnreachNlriImpl
    extends AbstractAugmentable<MpUnreachNlri>
    implements MpUnreachNlri {
        private final AddressFamily _afi;
        private final SubsequentAddressFamily _safi;
        private final WithdrawnRoutes _withdrawnRoutes;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MpUnreachNlriImpl(MpUnreachNlriBuilder base) {
            super(base.augmentation);
            this._afi = base.getAfi();
            this._safi = base.getSafi();
            this._withdrawnRoutes = base.getWithdrawnRoutes();
        }

        @Override
        public AddressFamily getAfi() {
            return this._afi;
        }

        @Override
        public SubsequentAddressFamily getSafi() {
            return this._safi;
        }

        @Override
        public WithdrawnRoutes getWithdrawnRoutes() {
            return this._withdrawnRoutes;
        }

        @Override
        public WithdrawnRoutes nonnullWithdrawnRoutes() {
            return Objects.requireNonNullElse(this.getWithdrawnRoutes(), WithdrawnRoutesBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = MpUnreachNlri.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return MpUnreachNlri.bindingEquals(this, obj);
        }

        public String toString() {
            return MpUnreachNlri.bindingToString(this);
        }
    }
}

