/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.MultiprotocolCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MultiprotocolCapabilityBuilder {
    private AddressFamily _afi;
    private SubsequentAddressFamily _safi;
    Map<Class<? extends Augmentation<MultiprotocolCapability>>, Augmentation<MultiprotocolCapability>> augmentation = Map.of();

    public MultiprotocolCapabilityBuilder() {
    }

    public MultiprotocolCapabilityBuilder(BgpTableType arg) {
        this._afi = arg.getAfi();
        this._safi = arg.getSafi();
    }

    public MultiprotocolCapabilityBuilder(MultiprotocolCapability base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MultiprotocolCapability>>, Augmentation<MultiprotocolCapability>>(aug);
        }
        this._afi = base.getAfi();
        this._safi = base.getSafi();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BgpTableType) {
            BgpTableType castArg = (BgpTableType)arg;
            this._afi = castArg.getAfi();
            this._safi = castArg.getSafi();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[BgpTableType]");
    }

    public static @NonNull MultiprotocolCapability empty() {
        return LazyEmpty.INSTANCE;
    }

    public AddressFamily getAfi() {
        return this._afi;
    }

    public SubsequentAddressFamily getSafi() {
        return this._safi;
    }

    public <E$$ extends Augmentation<MultiprotocolCapability>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public MultiprotocolCapabilityBuilder setAfi(AddressFamily value) {
        this._afi = value;
        return this;
    }

    public MultiprotocolCapabilityBuilder setSafi(SubsequentAddressFamily value) {
        this._safi = value;
        return this;
    }

    public MultiprotocolCapabilityBuilder addAugmentation(Augmentation<MultiprotocolCapability> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MultiprotocolCapability>>, Augmentation<MultiprotocolCapability>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public MultiprotocolCapabilityBuilder removeAugmentation(Class<? extends Augmentation<MultiprotocolCapability>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull MultiprotocolCapability build() {
        return new MultiprotocolCapabilityImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull MultiprotocolCapability INSTANCE = new MultiprotocolCapabilityBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class MultiprotocolCapabilityImpl
    extends AbstractAugmentable<MultiprotocolCapability>
    implements MultiprotocolCapability {
        private final AddressFamily _afi;
        private final SubsequentAddressFamily _safi;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MultiprotocolCapabilityImpl(MultiprotocolCapabilityBuilder base) {
            super(base.augmentation);
            this._afi = base.getAfi();
            this._safi = base.getSafi();
        }

        @Override
        public AddressFamily getAfi() {
            return this._afi;
        }

        @Override
        public SubsequentAddressFamily getSafi() {
            return this._safi;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = MultiprotocolCapability.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return MultiprotocolCapability.bindingEquals(this, obj);
        }

        public String toString() {
            return MultiprotocolCapability.bindingToString(this);
        }
    }
}

