/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.add.path.capability;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpAddPathTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.SendReceive;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.add.path.capability.AddressFamilies;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AddressFamiliesBuilder {
    private AddressFamily _afi;
    private SubsequentAddressFamily _safi;
    private SendReceive _sendReceive;
    Map<Class<? extends Augmentation<AddressFamilies>>, Augmentation<AddressFamilies>> augmentation = Map.of();

    public AddressFamiliesBuilder() {
    }

    public AddressFamiliesBuilder(BgpAddPathTableType arg) {
        this._sendReceive = arg.getSendReceive();
        this._afi = arg.getAfi();
        this._safi = arg.getSafi();
    }

    public AddressFamiliesBuilder(BgpTableType arg) {
        this._afi = arg.getAfi();
        this._safi = arg.getSafi();
    }

    public AddressFamiliesBuilder(AddressFamilies base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AddressFamilies>>, Augmentation<AddressFamilies>>(aug);
        }
        this._afi = base.getAfi();
        this._safi = base.getSafi();
        this._sendReceive = base.getSendReceive();
    }

    public void fieldsFrom(DataObject arg) {
        BgpTableType castArg;
        boolean isValidArg = false;
        if (arg instanceof BgpTableType) {
            castArg = (BgpTableType)arg;
            this._afi = castArg.getAfi();
            this._safi = castArg.getSafi();
            isValidArg = true;
        }
        if (arg instanceof BgpAddPathTableType) {
            castArg = (BgpAddPathTableType)arg;
            this._sendReceive = castArg.getSendReceive();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[BgpTableType, BgpAddPathTableType]");
    }

    public AddressFamily getAfi() {
        return this._afi;
    }

    public SubsequentAddressFamily getSafi() {
        return this._safi;
    }

    public SendReceive getSendReceive() {
        return this._sendReceive;
    }

    public <E$$ extends Augmentation<AddressFamilies>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public AddressFamiliesBuilder setAfi(AddressFamily value) {
        this._afi = value;
        return this;
    }

    public AddressFamiliesBuilder setSafi(SubsequentAddressFamily value) {
        this._safi = value;
        return this;
    }

    public AddressFamiliesBuilder setSendReceive(SendReceive value) {
        this._sendReceive = value;
        return this;
    }

    public AddressFamiliesBuilder addAugmentation(Augmentation<AddressFamilies> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AddressFamilies>>, Augmentation<AddressFamilies>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public AddressFamiliesBuilder removeAugmentation(Class<? extends Augmentation<AddressFamilies>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull AddressFamilies build() {
        return new AddressFamiliesImpl(this);
    }

    private static final class AddressFamiliesImpl
    extends AbstractAugmentable<AddressFamilies>
    implements AddressFamilies {
        private final AddressFamily _afi;
        private final SubsequentAddressFamily _safi;
        private final SendReceive _sendReceive;
        private int hash = 0;
        private volatile boolean hashValid = false;

        AddressFamiliesImpl(AddressFamiliesBuilder base) {
            super(base.augmentation);
            this._afi = base.getAfi();
            this._safi = base.getSafi();
            this._sendReceive = base.getSendReceive();
        }

        @Override
        public AddressFamily getAfi() {
            return this._afi;
        }

        @Override
        public SubsequentAddressFamily getSafi() {
            return this._safi;
        }

        @Override
        public SendReceive getSendReceive() {
            return this._sendReceive;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = AddressFamilies.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return AddressFamilies.bindingEquals(this, obj);
        }

        public String toString() {
            return AddressFamilies.bindingToString(this);
        }
    }
}

