/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.protocol.bgp.parser.BGPError;

public abstract class AbstractBGPException
extends Exception {
    private static final long serialVersionUID = 1L;
    private static final byte @NonNull [] EMPTY = new byte[0];
    private final @NonNull BGPError error;
    private final byte[] data;

    AbstractBGPException(String message, BGPError error, byte[] data, Exception cause) {
        super(message, cause);
        this.error = Objects.requireNonNull(error);
        this.data = data == null || data.length == 0 ? null : (byte[])data.clone();
    }

    public final BGPError getError() {
        return this.error;
    }

    public final byte @NonNull [] getData() {
        return this.data != null ? (byte[])this.data.clone() : EMPTY;
    }
}

