/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.GracefulRestartCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.graceful.restart.capability.Tables;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.graceful.restart.capability.TablesKey;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint16;

public class GracefulRestartCapabilityBuilder {
    private GracefulRestartCapability.RestartFlags _restartFlags;
    private Uint16 _restartTime;
    private Map<TablesKey, Tables> _tables;
    Map<Class<? extends Augmentation<GracefulRestartCapability>>, Augmentation<GracefulRestartCapability>> augmentation = Map.of();

    public GracefulRestartCapabilityBuilder() {
    }

    public GracefulRestartCapabilityBuilder(GracefulRestartCapability base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GracefulRestartCapability>>, Augmentation<GracefulRestartCapability>>(aug);
        }
        this._restartFlags = base.getRestartFlags();
        this._restartTime = base.getRestartTime();
        this._tables = base.getTables();
    }

    public GracefulRestartCapability.RestartFlags getRestartFlags() {
        return this._restartFlags;
    }

    public Uint16 getRestartTime() {
        return this._restartTime;
    }

    public Map<TablesKey, Tables> getTables() {
        return this._tables;
    }

    public <E$$ extends Augmentation<GracefulRestartCapability>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public GracefulRestartCapabilityBuilder setRestartFlags(GracefulRestartCapability.RestartFlags value) {
        this._restartFlags = value;
        return this;
    }

    private static void checkRestartTimeRange(int value) {
        if (value <= 4095) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4095]]", (int)value);
    }

    public GracefulRestartCapabilityBuilder setRestartTime(Uint16 value) {
        if (value != null) {
            GracefulRestartCapabilityBuilder.checkRestartTimeRange(value.intValue());
        }
        this._restartTime = value;
        return this;
    }

    public GracefulRestartCapabilityBuilder setTables(Map<TablesKey, Tables> values) {
        this._tables = values;
        return this;
    }

    public GracefulRestartCapabilityBuilder addAugmentation(Augmentation<GracefulRestartCapability> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GracefulRestartCapability>>, Augmentation<GracefulRestartCapability>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public GracefulRestartCapabilityBuilder removeAugmentation(Class<? extends Augmentation<GracefulRestartCapability>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull GracefulRestartCapability build() {
        return new GracefulRestartCapabilityImpl(this);
    }

    private static final class GracefulRestartCapabilityImpl
    extends AbstractAugmentable<GracefulRestartCapability>
    implements GracefulRestartCapability {
        private final GracefulRestartCapability.RestartFlags _restartFlags;
        private final Uint16 _restartTime;
        private final Map<TablesKey, Tables> _tables;
        private int hash = 0;
        private volatile boolean hashValid = false;

        GracefulRestartCapabilityImpl(GracefulRestartCapabilityBuilder base) {
            super(base.augmentation);
            this._restartFlags = base.getRestartFlags();
            this._restartTime = base.getRestartTime();
            this._tables = CodeHelpers.emptyToNull(base.getTables());
        }

        @Override
        public GracefulRestartCapability.RestartFlags getRestartFlags() {
            return this._restartFlags;
        }

        @Override
        public Uint16 getRestartTime() {
            return this._restartTime;
        }

        @Override
        public Map<TablesKey, Tables> getTables() {
            return this._tables;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = GracefulRestartCapability.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return GracefulRestartCapability.bindingEquals(this, obj);
        }

        public String toString() {
            return GracefulRestartCapability.bindingToString(this);
        }
    }
}

