/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedBytes;
import org.opendaylight.protocol.bgp.parser.AbstractBGPException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.BGPTreatAsWithdrawException;

public final class BGPDocumentedException
extends AbstractBGPException {
    private static final long serialVersionUID = -6212702584439430736L;

    public BGPDocumentedException(BGPError error) {
        this(null, error, null, null);
    }

    public BGPDocumentedException(String message, BGPError error) {
        this(message, error, null, null);
    }

    public BGPDocumentedException(String message, BGPError error, Exception cause) {
        this(message, error, null, cause);
    }

    public BGPDocumentedException(String message, BGPError error, byte[] data) {
        this(message, error, data, null);
    }

    public BGPDocumentedException(String message, BGPError error, byte[] data, Exception cause) {
        super(message, error, data, cause);
    }

    public BGPDocumentedException(BGPTreatAsWithdrawException cause) {
        this(cause.getMessage(), cause.getError(), cause.getData(), cause);
    }

    public static BGPDocumentedException badMessageLength(String message, int length) {
        Preconditions.checkArgument((length >= 0 && length <= 65535 ? 1 : 0) != 0);
        return new BGPDocumentedException(message, BGPError.BAD_MSG_LENGTH, new byte[]{UnsignedBytes.checkedCast((long)(length / 256)), UnsignedBytes.checkedCast((long)(length % 256))});
    }
}

