/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.Notify;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.NotifyMessage;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint8;

public class NotifyBuilder {
    private byte[] _data;
    private Uint8 _errorCode;
    private Uint8 _errorSubcode;
    Map<Class<? extends Augmentation<Notify>>, Augmentation<Notify>> augmentation = Map.of();

    public NotifyBuilder() {
    }

    public NotifyBuilder(NotifyMessage arg) {
        this._errorCode = arg.getErrorCode();
        this._errorSubcode = arg.getErrorSubcode();
        this._data = arg.getData();
    }

    public NotifyBuilder(Notify base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Notify>>, Augmentation<Notify>>(aug);
        }
        this._data = base.getData();
        this._errorCode = base.getErrorCode();
        this._errorSubcode = base.getErrorSubcode();
    }

    public void fieldsFrom(Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof NotifyMessage) {
            NotifyMessage castArg = (NotifyMessage)arg;
            this._errorCode = castArg.getErrorCode();
            this._errorSubcode = castArg.getErrorSubcode();
            this._data = castArg.getData();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[NotifyMessage]");
    }

    public byte[] getData() {
        return this._data == null ? null : (byte[])this._data.clone();
    }

    public Uint8 getErrorCode() {
        return this._errorCode;
    }

    public Uint8 getErrorSubcode() {
        return this._errorSubcode;
    }

    public <E$$ extends Augmentation<Notify>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public NotifyBuilder setData(byte[] value) {
        this._data = value;
        return this;
    }

    public NotifyBuilder setErrorCode(Uint8 value) {
        this._errorCode = value;
        return this;
    }

    public NotifyBuilder setErrorSubcode(Uint8 value) {
        this._errorSubcode = value;
        return this;
    }

    public NotifyBuilder addAugmentation(Augmentation<Notify> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Notify>>, Augmentation<Notify>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public NotifyBuilder removeAugmentation(Class<? extends Augmentation<Notify>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Notify build() {
        return new NotifyImpl(this);
    }

    private static final class NotifyImpl
    extends AbstractAugmentable<Notify>
    implements Notify {
        private final byte[] _data;
        private final Uint8 _errorCode;
        private final Uint8 _errorSubcode;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NotifyImpl(NotifyBuilder base) {
            super(base.augmentation);
            this._data = base.getData();
            this._errorCode = base.getErrorCode();
            this._errorSubcode = base.getErrorSubcode();
        }

        @Override
        public byte[] getData() {
            return this._data == null ? null : (byte[])this._data.clone();
        }

        @Override
        public Uint8 getErrorCode() {
            return this._errorCode;
        }

        @Override
        public Uint8 getErrorSubcode() {
            return this._errorSubcode;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Notify.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Notify.bindingEquals(this, obj);
        }

        public String toString() {
            return Notify.bindingToString(this);
        }
    }
}

