/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.OpenMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.BgpParameters;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint16;

public class OpenBuilder {
    private Ipv4AddressNoZone _bgpIdentifier;
    private List<BgpParameters> _bgpParameters;
    private Uint16 _holdTimer;
    private Uint16 _myAsNumber;
    private ProtocolVersion _version;
    Map<Class<? extends Augmentation<Open>>, Augmentation<Open>> augmentation = Map.of();

    public OpenBuilder() {
    }

    public OpenBuilder(OpenMessage arg) {
        this._version = arg.getVersion();
        this._myAsNumber = arg.getMyAsNumber();
        this._holdTimer = arg.getHoldTimer();
        this._bgpIdentifier = arg.getBgpIdentifier();
        this._bgpParameters = arg.getBgpParameters();
    }

    public OpenBuilder(Open base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Open>>, Augmentation<Open>>(aug);
        }
        this._bgpIdentifier = base.getBgpIdentifier();
        this._bgpParameters = base.getBgpParameters();
        this._holdTimer = base.getHoldTimer();
        this._myAsNumber = base.getMyAsNumber();
        this._version = base.getVersion();
    }

    public void fieldsFrom(Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof OpenMessage) {
            OpenMessage castArg = (OpenMessage)arg;
            this._version = castArg.getVersion();
            this._myAsNumber = castArg.getMyAsNumber();
            this._holdTimer = castArg.getHoldTimer();
            this._bgpIdentifier = castArg.getBgpIdentifier();
            this._bgpParameters = castArg.getBgpParameters();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[OpenMessage]");
    }

    public Ipv4AddressNoZone getBgpIdentifier() {
        return this._bgpIdentifier;
    }

    public List<BgpParameters> getBgpParameters() {
        return this._bgpParameters;
    }

    public Uint16 getHoldTimer() {
        return this._holdTimer;
    }

    public Uint16 getMyAsNumber() {
        return this._myAsNumber;
    }

    public ProtocolVersion getVersion() {
        return this._version;
    }

    public <E$$ extends Augmentation<Open>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public OpenBuilder setBgpIdentifier(Ipv4AddressNoZone value) {
        this._bgpIdentifier = value;
        return this;
    }

    public OpenBuilder setBgpParameters(List<BgpParameters> values) {
        this._bgpParameters = values;
        return this;
    }

    public OpenBuilder setHoldTimer(Uint16 value) {
        this._holdTimer = value;
        return this;
    }

    public OpenBuilder setMyAsNumber(Uint16 value) {
        this._myAsNumber = value;
        return this;
    }

    public OpenBuilder setVersion(ProtocolVersion value) {
        this._version = value;
        return this;
    }

    public OpenBuilder addAugmentation(Augmentation<Open> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Open>>, Augmentation<Open>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public OpenBuilder removeAugmentation(Class<? extends Augmentation<Open>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Open build() {
        return new OpenImpl(this);
    }

    private static final class OpenImpl
    extends AbstractAugmentable<Open>
    implements Open {
        private final Ipv4AddressNoZone _bgpIdentifier;
        private final List<BgpParameters> _bgpParameters;
        private final Uint16 _holdTimer;
        private final Uint16 _myAsNumber;
        private final ProtocolVersion _version;
        private int hash = 0;
        private volatile boolean hashValid = false;

        OpenImpl(OpenBuilder base) {
            super(base.augmentation);
            this._bgpIdentifier = base.getBgpIdentifier();
            this._bgpParameters = CodeHelpers.emptyToNull(base.getBgpParameters());
            this._holdTimer = base.getHoldTimer();
            this._myAsNumber = base.getMyAsNumber();
            this._version = base.getVersion();
        }

        @Override
        public Ipv4AddressNoZone getBgpIdentifier() {
            return this._bgpIdentifier;
        }

        @Override
        public List<BgpParameters> getBgpParameters() {
            return this._bgpParameters;
        }

        @Override
        public Uint16 getHoldTimer() {
            return this._holdTimer;
        }

        @Override
        public Uint16 getMyAsNumber() {
            return this._myAsNumber;
        }

        @Override
        public ProtocolVersion getVersion() {
            return this._version;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Open.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Open.bindingEquals(this, obj);
        }

        public String toString() {
            return Open.bindingToString(this);
        }
    }
}

