/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Aggregator;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AggregatorBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Aigp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AigpBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AsPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AsPathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AtomicAggregate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.BgpPrefixSid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.BgpPrefixSidBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ClusterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ClusterIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Communities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ExtendedCommunities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.LocalPref;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.LocalPrefBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.MultiExitDisc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.MultiExitDiscBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Origin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.OriginBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.OriginatorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.OriginatorIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.UnrecognizedAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.UnrecognizedAttributesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.NextHop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.CNextHop;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

public class AttributesBuilder {
    private Aggregator _aggregator;
    private Aigp _aigp;
    private AsPath _asPath;
    private AtomicAggregate _atomicAggregate;
    private BgpPrefixSid _bgpPrefixSid;
    private CNextHop _cNextHop;
    private ClusterId _clusterId;
    private List<Communities> _communities;
    private List<ExtendedCommunities> _extendedCommunities;
    private LocalPref _localPref;
    private MultiExitDisc _multiExitDisc;
    private Origin _origin;
    private OriginatorId _originatorId;
    private Map<UnrecognizedAttributesKey, UnrecognizedAttributes> _unrecognizedAttributes;
    Map<Class<? extends Augmentation<Attributes>>, Augmentation<Attributes>> augmentation = Map.of();

    public AttributesBuilder() {
    }

    public AttributesBuilder(NextHop arg) {
        this._cNextHop = arg.getCNextHop();
    }

    public AttributesBuilder(Attributes base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Attributes>>, Augmentation<Attributes>>(aug);
        }
        this._aggregator = base.getAggregator();
        this._aigp = base.getAigp();
        this._asPath = base.getAsPath();
        this._atomicAggregate = base.getAtomicAggregate();
        this._bgpPrefixSid = base.getBgpPrefixSid();
        this._cNextHop = base.getCNextHop();
        this._clusterId = base.getClusterId();
        this._communities = base.getCommunities();
        this._extendedCommunities = base.getExtendedCommunities();
        this._localPref = base.getLocalPref();
        this._multiExitDisc = base.getMultiExitDisc();
        this._origin = base.getOrigin();
        this._originatorId = base.getOriginatorId();
        this._unrecognizedAttributes = base.getUnrecognizedAttributes();
    }

    public void fieldsFrom(Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof NextHop) {
            NextHop castArg = (NextHop)arg;
            this._cNextHop = castArg.getCNextHop();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[NextHop]");
    }

    public static @NonNull Attributes empty() {
        return LazyEmpty.INSTANCE;
    }

    public Aggregator getAggregator() {
        return this._aggregator;
    }

    public Aigp getAigp() {
        return this._aigp;
    }

    public AsPath getAsPath() {
        return this._asPath;
    }

    public AtomicAggregate getAtomicAggregate() {
        return this._atomicAggregate;
    }

    public BgpPrefixSid getBgpPrefixSid() {
        return this._bgpPrefixSid;
    }

    public CNextHop getCNextHop() {
        return this._cNextHop;
    }

    public ClusterId getClusterId() {
        return this._clusterId;
    }

    public List<Communities> getCommunities() {
        return this._communities;
    }

    public List<ExtendedCommunities> getExtendedCommunities() {
        return this._extendedCommunities;
    }

    public LocalPref getLocalPref() {
        return this._localPref;
    }

    public MultiExitDisc getMultiExitDisc() {
        return this._multiExitDisc;
    }

    public Origin getOrigin() {
        return this._origin;
    }

    public OriginatorId getOriginatorId() {
        return this._originatorId;
    }

    public Map<UnrecognizedAttributesKey, UnrecognizedAttributes> getUnrecognizedAttributes() {
        return this._unrecognizedAttributes;
    }

    public <E$$ extends Augmentation<Attributes>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public AttributesBuilder setAggregator(Aggregator value) {
        this._aggregator = value;
        return this;
    }

    public AttributesBuilder setAigp(Aigp value) {
        this._aigp = value;
        return this;
    }

    public AttributesBuilder setAsPath(AsPath value) {
        this._asPath = value;
        return this;
    }

    public AttributesBuilder setAtomicAggregate(AtomicAggregate value) {
        this._atomicAggregate = value;
        return this;
    }

    public AttributesBuilder setBgpPrefixSid(BgpPrefixSid value) {
        this._bgpPrefixSid = value;
        return this;
    }

    public AttributesBuilder setCNextHop(CNextHop value) {
        this._cNextHop = value;
        return this;
    }

    public AttributesBuilder setClusterId(ClusterId value) {
        this._clusterId = value;
        return this;
    }

    public AttributesBuilder setCommunities(List<Communities> values) {
        this._communities = values;
        return this;
    }

    public AttributesBuilder setExtendedCommunities(List<ExtendedCommunities> values) {
        this._extendedCommunities = values;
        return this;
    }

    public AttributesBuilder setLocalPref(LocalPref value) {
        this._localPref = value;
        return this;
    }

    public AttributesBuilder setMultiExitDisc(MultiExitDisc value) {
        this._multiExitDisc = value;
        return this;
    }

    public AttributesBuilder setOrigin(Origin value) {
        this._origin = value;
        return this;
    }

    public AttributesBuilder setOriginatorId(OriginatorId value) {
        this._originatorId = value;
        return this;
    }

    public AttributesBuilder setUnrecognizedAttributes(Map<UnrecognizedAttributesKey, UnrecognizedAttributes> values) {
        this._unrecognizedAttributes = values;
        return this;
    }

    public AttributesBuilder addAugmentation(Augmentation<Attributes> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Attributes>>, Augmentation<Attributes>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public AttributesBuilder removeAugmentation(Class<? extends Augmentation<Attributes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Attributes build() {
        return new AttributesImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull Attributes INSTANCE = new AttributesBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class AttributesImpl
    extends AbstractAugmentable<Attributes>
    implements Attributes {
        private final Aggregator _aggregator;
        private final Aigp _aigp;
        private final AsPath _asPath;
        private final AtomicAggregate _atomicAggregate;
        private final BgpPrefixSid _bgpPrefixSid;
        private final CNextHop _cNextHop;
        private final ClusterId _clusterId;
        private final List<Communities> _communities;
        private final List<ExtendedCommunities> _extendedCommunities;
        private final LocalPref _localPref;
        private final MultiExitDisc _multiExitDisc;
        private final Origin _origin;
        private final OriginatorId _originatorId;
        private final Map<UnrecognizedAttributesKey, UnrecognizedAttributes> _unrecognizedAttributes;
        private int hash = 0;
        private volatile boolean hashValid = false;

        AttributesImpl(AttributesBuilder base) {
            super(base.augmentation);
            this._aggregator = base.getAggregator();
            this._aigp = base.getAigp();
            this._asPath = base.getAsPath();
            this._atomicAggregate = base.getAtomicAggregate();
            this._bgpPrefixSid = base.getBgpPrefixSid();
            this._cNextHop = base.getCNextHop();
            this._clusterId = base.getClusterId();
            this._communities = CodeHelpers.emptyToNull(base.getCommunities());
            this._extendedCommunities = CodeHelpers.emptyToNull(base.getExtendedCommunities());
            this._localPref = base.getLocalPref();
            this._multiExitDisc = base.getMultiExitDisc();
            this._origin = base.getOrigin();
            this._originatorId = base.getOriginatorId();
            this._unrecognizedAttributes = CodeHelpers.emptyToNull(base.getUnrecognizedAttributes());
        }

        @Override
        public Aggregator getAggregator() {
            return this._aggregator;
        }

        @Override
        public Aigp getAigp() {
            return this._aigp;
        }

        @Override
        public AsPath getAsPath() {
            return this._asPath;
        }

        @Override
        public AtomicAggregate getAtomicAggregate() {
            return this._atomicAggregate;
        }

        @Override
        public BgpPrefixSid getBgpPrefixSid() {
            return this._bgpPrefixSid;
        }

        public CNextHop getCNextHop() {
            return this._cNextHop;
        }

        @Override
        public ClusterId getClusterId() {
            return this._clusterId;
        }

        @Override
        public List<Communities> getCommunities() {
            return this._communities;
        }

        @Override
        public List<ExtendedCommunities> getExtendedCommunities() {
            return this._extendedCommunities;
        }

        @Override
        public LocalPref getLocalPref() {
            return this._localPref;
        }

        @Override
        public MultiExitDisc getMultiExitDisc() {
            return this._multiExitDisc;
        }

        @Override
        public Origin getOrigin() {
            return this._origin;
        }

        @Override
        public OriginatorId getOriginatorId() {
            return this._originatorId;
        }

        @Override
        public Map<UnrecognizedAttributesKey, UnrecognizedAttributes> getUnrecognizedAttributes() {
            return this._unrecognizedAttributes;
        }

        @Override
        public Aggregator nonnullAggregator() {
            return Objects.requireNonNullElse(this.getAggregator(), AggregatorBuilder.empty());
        }

        @Override
        public Aigp nonnullAigp() {
            return Objects.requireNonNullElse(this.getAigp(), AigpBuilder.empty());
        }

        @Override
        public AsPath nonnullAsPath() {
            return Objects.requireNonNullElse(this.getAsPath(), AsPathBuilder.empty());
        }

        @Override
        public BgpPrefixSid nonnullBgpPrefixSid() {
            return Objects.requireNonNullElse(this.getBgpPrefixSid(), BgpPrefixSidBuilder.empty());
        }

        @Override
        public ClusterId nonnullClusterId() {
            return Objects.requireNonNullElse(this.getClusterId(), ClusterIdBuilder.empty());
        }

        @Override
        public LocalPref nonnullLocalPref() {
            return Objects.requireNonNullElse(this.getLocalPref(), LocalPrefBuilder.empty());
        }

        @Override
        public MultiExitDisc nonnullMultiExitDisc() {
            return Objects.requireNonNullElse(this.getMultiExitDisc(), MultiExitDiscBuilder.empty());
        }

        @Override
        public Origin nonnullOrigin() {
            return Objects.requireNonNullElse(this.getOrigin(), OriginBuilder.empty());
        }

        @Override
        public OriginatorId nonnullOriginatorId() {
            return Objects.requireNonNullElse(this.getOriginatorId(), OriginatorIdBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Attributes.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Attributes.bindingEquals(this, obj);
        }

        public String toString() {
            return Attributes.bindingToString(this);
        }
    }
}

