/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.RouteRefresh;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

public class RouteRefreshBuilder {
    private AddressFamily _afi;
    private SubsequentAddressFamily _safi;
    Map<Class<? extends Augmentation<RouteRefresh>>, Augmentation<RouteRefresh>> augmentation = Map.of();

    public RouteRefreshBuilder() {
    }

    public RouteRefreshBuilder(BgpTableType arg) {
        this._afi = arg.getAfi();
        this._safi = arg.getSafi();
    }

    public RouteRefreshBuilder(RouteRefresh base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RouteRefresh>>, Augmentation<RouteRefresh>>(aug);
        }
        this._afi = base.getAfi();
        this._safi = base.getSafi();
    }

    public void fieldsFrom(Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof BgpTableType) {
            BgpTableType castArg = (BgpTableType)arg;
            this._afi = castArg.getAfi();
            this._safi = castArg.getSafi();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[BgpTableType]");
    }

    public AddressFamily getAfi() {
        return this._afi;
    }

    public SubsequentAddressFamily getSafi() {
        return this._safi;
    }

    public <E$$ extends Augmentation<RouteRefresh>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public RouteRefreshBuilder setAfi(AddressFamily value) {
        this._afi = value;
        return this;
    }

    public RouteRefreshBuilder setSafi(SubsequentAddressFamily value) {
        this._safi = value;
        return this;
    }

    public RouteRefreshBuilder addAugmentation(Augmentation<RouteRefresh> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RouteRefresh>>, Augmentation<RouteRefresh>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public RouteRefreshBuilder removeAugmentation(Class<? extends Augmentation<RouteRefresh>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull RouteRefresh build() {
        return new RouteRefreshImpl(this);
    }

    private static final class RouteRefreshImpl
    extends AbstractAugmentable<RouteRefresh>
    implements RouteRefresh {
        private final AddressFamily _afi;
        private final SubsequentAddressFamily _safi;
        private int hash = 0;
        private volatile boolean hashValid = false;

        RouteRefreshImpl(RouteRefreshBuilder base) {
            super(base.augmentation);
            this._afi = base.getAfi();
            this._safi = base.getSafi();
        }

        @Override
        public AddressFamily getAfi() {
            return this._afi;
        }

        @Override
        public SubsequentAddressFamily getSafi() {
            return this._safi;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = RouteRefresh.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return RouteRefresh.bindingEquals(this, obj);
        }

        public String toString() {
            return RouteRefresh.bindingToString(this);
        }
    }
}

