/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.graceful.restart.capability;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.graceful.restart.capability.Tables;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.graceful.restart.capability.TablesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.lib.AbstractEntryObject;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

public class TablesBuilder {
    private AddressFamily _afi;
    private Tables.AfiFlags _afiFlags;
    private SubsequentAddressFamily _safi;
    private TablesKey key;
    Map<Class<? extends Augmentation<Tables>>, Augmentation<Tables>> augmentation = Map.of();

    public TablesBuilder() {
    }

    public TablesBuilder(BgpTableType arg) {
        this._afi = arg.getAfi();
        this._safi = arg.getSafi();
    }

    public TablesBuilder(Tables base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Tables>>, Augmentation<Tables>>(aug);
        }
        this.key = base.key();
        this._afi = base.getAfi();
        this._safi = base.getSafi();
        this._afiFlags = base.getAfiFlags();
    }

    public void fieldsFrom(Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof BgpTableType) {
            BgpTableType castArg = (BgpTableType)arg;
            this._afi = castArg.getAfi();
            this._safi = castArg.getSafi();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[BgpTableType]");
    }

    public TablesKey key() {
        return this.key;
    }

    public AddressFamily getAfi() {
        return this._afi;
    }

    public Tables.AfiFlags getAfiFlags() {
        return this._afiFlags;
    }

    public SubsequentAddressFamily getSafi() {
        return this._safi;
    }

    public <E$$ extends Augmentation<Tables>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public TablesBuilder withKey(TablesKey key) {
        this.key = key;
        return this;
    }

    public TablesBuilder setAfi(AddressFamily value) {
        this._afi = value;
        return this;
    }

    public TablesBuilder setAfiFlags(Tables.AfiFlags value) {
        this._afiFlags = value;
        return this;
    }

    public TablesBuilder setSafi(SubsequentAddressFamily value) {
        this._safi = value;
        return this;
    }

    public TablesBuilder addAugmentation(Augmentation<Tables> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Tables>>, Augmentation<Tables>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public TablesBuilder removeAugmentation(Class<? extends Augmentation<Tables>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Tables build() {
        return new TablesImpl(this);
    }

    private static final class TablesImpl
    extends AbstractEntryObject<Tables, TablesKey>
    implements Tables {
        private final AddressFamily _afi;
        private final Tables.AfiFlags _afiFlags;
        private final SubsequentAddressFamily _safi;
        private int hash = 0;
        private volatile boolean hashValid = false;

        TablesImpl(TablesBuilder base) {
            super(base.augmentation, (Key)TablesImpl.extractKey(base));
            TablesKey key = (TablesKey)this.key();
            this._afi = key.getAfi();
            this._safi = key.getSafi();
            this._afiFlags = base.getAfiFlags();
        }

        private static @NonNull TablesKey extractKey(TablesBuilder base) {
            TablesKey key = base.key();
            return key != null ? key : new TablesKey(base.getAfi(), base.getSafi());
        }

        @Override
        public AddressFamily getAfi() {
            return this._afi;
        }

        @Override
        public Tables.AfiFlags getAfiFlags() {
            return this._afiFlags;
        }

        @Override
        public SubsequentAddressFamily getSafi() {
            return this._safi;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Tables.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Tables.bindingEquals(this, obj);
        }

        public String toString() {
            return Tables.bindingToString(this);
        }
    }
}

