package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.binding.DataRoot;

/**
 * This module contains the base data model of a BGP message. It rolls up the 
 * definitions contained in RFC4271 and RFC4893. Copyright (c)2013 Cisco Systems, 
 * Inc. All rights reserved. This program and the accompanying materials are made 
 * available under the terms of the Eclipse Public License v1.0 which accompanies 
 * this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-message</b>
 * <pre>
 * module bgp-message {
 *   yang-version 1;
 *   namespace urn:opendaylight:params:xml:ns:yang:bgp-message;
 *   prefix bgp-msg;
 *   import ietf-inet-types {
 *     prefix inet;
 *     revision-date 2013-07-15;
 *   }
 *   import bgp-types {
 *     prefix bgp-t;
 *     revision-date 2020-01-20;
 *   }
 *   import network-concepts {
 *     prefix netc;
 *     revision-date 2013-11-25;
 *   }
 *   revision 2020-01-20 {
 *   }
 *   revision 2018-03-29 {
 *   }
 *   revision 2017-12-07 {
 *   }
 *   revision 2013-09-19 {
 *   }
 *   revision 2013-09-18 {
 *   }
 *   typedef protocol-version {
 *     type uint8 {
 *       range 1..7;
 *     }
 *   }
 *   typedef path-id {
 *     type uint32;
 *     default 0;
 *   }
 *   grouping path-id-grouping {
 *     leaf path-id {
 *       type path-id;
 *     }
 *   }
 *   grouping originator-id {
 *     leaf originator {
 *       type inet:ipv4-address-no-zone;
 *     }
 *   }
 *   grouping cluster-id {
 *     leaf-list cluster {
 *       type bgp-t:cluster-identifier;
 *       ordered-by user;
 *     }
 *   }
 *   grouping ipv4-prefix-and-path-id {
 *     leaf prefix {
 *       type inet:ipv4-prefix;
 *     }
 *     uses path-id-grouping;
 *   }
 *   notification open {
 *     uses open-message;
 *   }
 *   grouping open-message {
 *     leaf version {
 *       type protocol-version;
 *       default 4;
 *     }
 *     leaf my-as-number {
 *       type uint16;
 *       default 23456;
 *     }
 *     leaf hold-timer {
 *       type uint16;
 *     }
 *     leaf bgp-identifier {
 *       type inet:ipv4-address-no-zone;
 *     }
 *     list bgp-parameters {
 *       list optional-capabilities {
 *         container c-parameters {
 *           container as4-bytes-capability {
 *             leaf as-number {
 *               type inet:as-number;
 *             }
 *           }
 *           container bgp-extended-message-capability {
 *             presence "Indicates peer is able to send/receive 64K messages";
 *           }
 *         }
 *       }
 *     }
 *   }
 *   grouping path-attributes {
 *     container attributes {
 *       container origin {
 *         leaf value {
 *           type bgp-t:bgp-origin;
 *         }
 *       }
 *       container as-path {
 *         list segments {
 *           uses bgp-t:as-path-segment;
 *         }
 *       }
 *       uses bgp-t:next-hop;
 *       container multi-exit-disc {
 *         leaf med {
 *           type uint32;
 *         }
 *       }
 *       container local-pref {
 *         leaf pref {
 *           type uint32;
 *         }
 *       }
 *       container atomic-aggregate {
 *         presence "Atomic Aggregate attribute is present.";
 *       }
 *       container aggregator {
 *         uses bgp-t:bgp-aggregator;
 *       }
 *       list communities {
 *         uses bgp-t:community;
 *       }
 *       list extended-communities {
 *         uses bgp-t:extended-community;
 *       }
 *       container originator-id {
 *         uses originator-id;
 *       }
 *       container cluster-id {
 *         uses cluster-id;
 *       }
 *       container aigp {
 *         container aigp-tlv {
 *           leaf metric {
 *             type netc:accumulated-igp-metric;
 *           }
 *         }
 *       }
 *       list unrecognized-attributes {
 *         key type;
 *         leaf partial {
 *           type boolean;
 *         }
 *         leaf transitive {
 *           type boolean;
 *         }
 *         leaf type {
 *           type uint8;
 *         }
 *         leaf value {
 *           type binary {
 *             length 0..65535;
 *           }
 *         }
 *       }
 *       container bgp-prefix-sid {
 *         list bgp-prefix-sid-tlvs {
 *           choice bgp-prefix-sid-tlv {
 *           }
 *         }
 *       }
 *     }
 *   }
 *   notification update {
 *     uses update-message;
 *   }
 *   grouping update-message {
 *     uses path-attributes;
 *     list withdrawn-routes {
 *       uses ipv4-prefix-and-path-id;
 *     }
 *     list nlri {
 *       uses ipv4-prefix-and-path-id;
 *     }
 *   }
 *   notification keepalive {
 *   }
 *   notification notify {
 *     uses notify-message;
 *   }
 *   grouping notify-message {
 *     leaf error-code {
 *       type uint8;
 *     }
 *     leaf error-subcode {
 *       type uint8;
 *     }
 *     leaf data {
 *       type binary;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface BgpMessageData
    extends
    DataRoot<BgpMessageData>
{




    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.BgpMessageData> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.BgpMessageData.class;
    }

}

