package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ClusterIdentifier;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-message</b>
 * <pre>
 * grouping cluster-id {
 *   leaf-list cluster {
 *     type bgp-t:cluster-identifier;
 *     ordered-by user;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface ClusterId
    extends
    Grouping
{




    /**
     * Return cluster, or {@code null} if it is not present.
     *
     * @return {@code List<ClusterIdentifier>} cluster, or {@code null} if it is not present.
     *
     */
    @Nullable List<ClusterIdentifier> getCluster();
    
    /**
     * Return cluster, guaranteed to be non-null.
     *
     * @return {@code List<ClusterIdentifier>} cluster, guaranteed to be non-null.
     * @throws NoSuchElementException if cluster is not present
     *
     */
    default @NonNull List<ClusterIdentifier> requireCluster() {
        return CodeHelpers.require(getCluster(), "cluster");
    }

}

