package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link Notify} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Notify createNotify(int fooXyzzy, int barBaz) {
 *         return new NotifyBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Notify, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Notify
 *
 */
@Generated("mdsal-binding-generator")
public class NotifyBuilder {

    private byte[] _data;
    private Uint8 _errorCode;
    private Uint8 _errorSubcode;


    Map<Class<? extends Augmentation<Notify>>, Augmentation<Notify>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public NotifyBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link NotifyMessage}.
     *
     * @param arg NotifyMessage from which the builder should be initialized
     */
    public NotifyBuilder(NotifyMessage arg) {
        this._errorCode = arg.getErrorCode();
        this._errorSubcode = arg.getErrorSubcode();
        this._data = arg.getData();
    }
    
    

    /**
     * Construct a builder initialized with state from specified {@link Notify}.
     *
     * @param base Notify from which the builder should be initialized
     */
    public NotifyBuilder(final Notify base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._data = base.getData();
        this._errorCode = base.getErrorCode();
        this._errorSubcode = base.getErrorSubcode();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link NotifyMessage}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(final Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof NotifyMessage castArg) {
            this._errorCode = castArg.getErrorCode();
            this._errorSubcode = castArg.getErrorSubcode();
            this._data = castArg.getData();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[NotifyMessage]");
    }


    /**
     * Return current value associated with the property corresponding to {@link Notify#getData()}.
     *
     * @return current value
     */
    public byte[] getData() {
        return _data == null ? null : _data.clone();
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Notify#getErrorCode()}.
     *
     * @return current value
     */
    public Uint8 getErrorCode() {
        return _errorCode;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Notify#getErrorSubcode()}.
     *
     * @return current value
     */
    public Uint8 getErrorSubcode() {
        return _errorSubcode;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Notify>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Notify#getData()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public NotifyBuilder setData(final byte[] value) {
        this._data = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Notify#getErrorCode()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public NotifyBuilder setErrorCode(final Uint8 value) {
        this._errorCode = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Notify#getErrorSubcode()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public NotifyBuilder setErrorSubcode(final Uint8 value) {
        this._errorSubcode = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NotifyBuilder addAugmentation(Augmentation<Notify> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NotifyBuilder removeAugmentation(Class<? extends Augmentation<Notify>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Notify} instance.
     *
     * @return A new {@link Notify} instance.
     */
    public @NonNull Notify build() {
        return new NotifyImpl(this);
    }

    private static final class NotifyImpl
        extends AbstractAugmentable<Notify>
        implements Notify {
    
        private final byte[] _data;
        private final Uint8 _errorCode;
        private final Uint8 _errorSubcode;
    
        NotifyImpl(final NotifyBuilder base) {
            super(base.augmentation);
            this._data = base.getData();
            this._errorCode = base.getErrorCode();
            this._errorSubcode = base.getErrorSubcode();
        }
    
        @Override
        public byte[] getData() {
            return _data == null ? null : _data.clone();
        }
        
        @Override
        public Uint8 getErrorCode() {
            return _errorCode;
        }
        
        @Override
        public Uint8 getErrorSubcode() {
            return _errorSubcode;
        }
    
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Notify.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Notify.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Notify.bindingToString(this);
        }
    }
}
